/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.openl.info.OpenLVersion;
import org.openl.util.IOUtils;

final class JarArchiver
extends SimpleFileVisitor<Path> {
    private static final int BUFFER_SIZE = 65536;
    private static final Pattern BACK_SLASH = Pattern.compile("\\\\");
    private final Path dir;
    private final JarOutputStream zos;
    private final byte[] buffer = new byte[65536];

    private JarArchiver(Path dir, JarOutputStream zos) {
        this.dir = dir;
        this.zos = zos;
    }

    static void archive(File sourceDir, File file) throws IOException {
        Path path = sourceDir.toPath();
        Manifest man = new Manifest();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Created-By", "OpenL Maven Plugin v" + OpenLVersion.getVersion());
        try (JarOutputStream zos = new JarOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), man);){
            Files.walkFileTree(path, new JarArchiver(path, zos));
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String relativePath = this.dir.relativize(file).toString();
        String zipPath = BACK_SLASH.matcher(relativePath).replaceAll("/");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            JarEntry entry = new JarEntry(zipPath);
            this.zos.putNextEntry(entry);
            IOUtils.copy((InputStream)fis, (OutputStream)this.zos, (byte[])this.buffer);
        }
        return FileVisitResult.CONTINUE;
    }
}

