/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.openl.info.OpenLVersion;
import org.openl.rules.dataformat.yaml.YamlMapperFactory;
import org.openl.rules.maven.BaseOpenLMojo;
import org.openl.rules.maven.JarArchiver;
import org.openl.util.CollectionUtils;
import org.openl.util.FileUtils;
import org.openl.util.ProjectPackager;
import org.openl.util.StringUtils;
import org.openl.util.ZipArchiver;
import org.openl.util.ZipUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public final class PackageMojo
extends BaseOpenLMojo {
    private static final String DEPLOYMENT_YAML = "deployment.yaml";
    static final String DEPLOYMENT_CLASSIFIER = "deployment";
    private static final String OPENL_ARTIFACT_TYPE = "zip";
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    private String packaging;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File classesDirectory;
    @Parameter(defaultValue="zip")
    private String format;
    @Parameter(defaultValue="lib/")
    private String classpathFolder;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="3", required=true)
    private int dependenciesThreshold;
    @Parameter(defaultValue="false")
    private boolean deploymentPackage;
    @Parameter(defaultValue="${project.build.finalName}")
    private String deploymentName;
    @Parameter(defaultValue="true")
    private boolean addDefaultManifest;
    @Parameter
    private Map<String, String> manifestEntries;
    @Parameter(defaultValue="${user.name}", readonly=true, required=true)
    private String userName;
    @Parameter
    private String[] includes;
    @Parameter
    private final String[] excludes = StringUtils.EMPTY_STRING_ARRAY;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    private String projectBaseDir;

    @Override
    void execute(String sourcePath, boolean hasDependencies) throws Exception {
        boolean mainArtifactExists;
        File openLSourceDir = new File(sourcePath);
        if (CollectionUtils.isEmpty((Object[])openLSourceDir.list())) {
            this.info("No OpenL sources have been found at '", sourcePath, "' path");
            this.info("Skipping packaging of the empty OpenL project.", new Object[0]);
            return;
        }
        Object[] types = this.getFormats();
        if (CollectionUtils.isEmpty((Object[])types)) {
            throw new MojoFailureException("No formats have been defined in the plugin configuration.");
        }
        File dependencyLib = this.project.getArtifact().getFile();
        boolean bl = mainArtifactExists = dependencyLib != null && dependencyLib.isFile();
        if (mainArtifactExists && StringUtils.isBlank((CharSequence)this.classifier) && Arrays.asList(types).contains(this.packaging)) {
            this.error("The main artifact have been attached already.", new Object[0]);
            this.error("You have to use classifier to attach supplemental artifacts to the project instead of replacing them.", new Object[0]);
            throw new MojoFailureException("It is not possible to replace the main artifact.");
        }
        Set<Artifact> dependencies = this.getDependencies();
        int dependenciesSize = dependencies.size();
        if (dependenciesSize > this.dependenciesThreshold) {
            this.error("The quantity of dependencies (", dependenciesSize, ") exceeds the defined threshold in 'dependenciesThreshold=", this.dependenciesThreshold, "' parameter.");
            for (Artifact artifact : dependencies) {
                this.error("    : ", artifact);
            }
            throw new MojoFailureException("The quantity of dependencies exceeds the limit");
        }
        boolean openLJarPackaging = this.packaging.equals("openl-jar");
        if (!mainArtifactExists && CollectionUtils.isNotEmpty((Object[])this.classesDirectory.list()) && !openLJarPackaging) {
            dependencyLib = File.createTempFile(this.finalName, "-lib.jar", this.outputDirectory);
            JarArchiver.archive(this.classesDirectory, dependencyLib);
        }
        DirectoryScanner dirScan = new DirectoryScanner();
        dirScan.setBasedir(openLSourceDir);
        dirScan.setExcludes(this.getExcludes());
        dirScan.setIncludes(this.includes);
        dirScan.scan();
        String[] includedFiles = dirScan.getIncludedFiles();
        for (Object type : types) {
            File outputFile = this.getOutputFile(this.outputDirectory, this.finalName, this.classifier, (String)type);
            boolean itselfLink = outputFile.equals(dependencyLib);
            try (ZipArchiver arch = new ZipArchiver(outputFile.toPath());){
                if (this.addDefaultManifest || this.manifestEntries != null) {
                    Manifest manifest = this.createManifest();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    arch.addFile((InputStream)new ByteArrayInputStream(baos.toByteArray()), "META-INF/MANIFEST.MF");
                }
                if (openLJarPackaging && CollectionUtils.isNotEmpty((Object[])this.classesDirectory.list())) {
                    ProjectPackager.addOpenLProject((File)this.classesDirectory, (ZipArchiver)arch);
                }
                ProjectPackager.addOpenLProject((File)openLSourceDir, (String[])includedFiles, (ZipArchiver)arch);
                if (dependencyLib != null && dependencyLib.isFile() && !itselfLink) {
                    arch.addFile(dependencyLib, this.classpathFolder + this.finalName + ".jar");
                }
                for (Artifact artifact : dependencies) {
                    File file = artifact.getFile();
                    arch.addFile(file, this.classpathFolder + file.getName());
                }
            }
            if (mainArtifactExists || StringUtils.isNotBlank((CharSequence)this.classifier)) {
                this.info("Attaching the supplemental artifact '", outputFile, ",");
                this.projectHelper.attachArtifact(this.project, (String)type, this.classifier, outputFile);
                continue;
            }
            this.info("Registering the main artifact '", outputFile, ",");
            mainArtifactExists = true;
            this.project.getArtifact().setFile(outputFile);
        }
        if (this.deploymentPackage && (openLJarPackaging || "openl".equals(this.packaging))) {
            File outputDeploymentDir = new File(this.outputDirectory, this.finalName + "-deployment");
            if (outputDeploymentDir.isDirectory()) {
                this.info("Cleaning up '", outputDeploymentDir, "' directory...");
                FileUtils.delete((File)outputDeploymentDir);
            }
            outputDeploymentDir.mkdir();
            Set<Artifact> openLDependencies = this.getDependentOpenLProjects();
            for (Artifact openLArtifact : openLDependencies) {
                if (!this.isRuntimeScope(openLArtifact.getScope())) continue;
                this.debug("ADD : ", openLArtifact);
                File artifactFile = openLArtifact.getFile();
                this.unpackZip(outputDeploymentDir, openLArtifact.getArtifactId(), artifactFile);
            }
            this.unpackZip(outputDeploymentDir, this.project.getArtifact().getArtifactId(), this.project.getArtifact().getFile());
            this.generateDeploymentFile(outputDeploymentDir);
            String artifactType = this.getFormats()[0];
            File outputFile = this.getOutputFile(this.outputDirectory, this.deploymentName, DEPLOYMENT_CLASSIFIER, artifactType);
            ZipUtils.archive((File)outputDeploymentDir, (File)outputFile);
            this.info("Attaching the deployment artifact '", outputFile, ",");
            this.projectHelper.attachArtifact(this.project, artifactType, DEPLOYMENT_CLASSIFIER, outputFile);
        }
    }

    private String[] getFormats() {
        switch (this.packaging) {
            case "openl": {
                return new String[]{OPENL_ARTIFACT_TYPE};
            }
            case "openl-jar": {
                return new String[]{"jar"};
            }
        }
        return StringUtils.split((String)this.format, (char)',');
    }

    private Set<Artifact> getDependencies() {
        HashSet<String> allowed = this.getAllowedDependencies();
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        for (Artifact artifact : this.getDependentNonOpenLProjects()) {
            String scope;
            String type;
            String groupId = artifact.getGroupId();
            if (this.skipToProcess(groupId, type = artifact.getType(), scope = artifact.getScope())) {
                this.debug("SKIP : ", artifact);
                continue;
            }
            List dependencyTrail = artifact.getDependencyTrail();
            if (dependencyTrail.size() < 2) {
                this.debug("SKIP : ", artifact, " (by dependency depth)");
                continue;
            }
            if (PackageMojo.skipOpenLCoreDependency(dependencyTrail)) {
                this.debug("SKIP : ", artifact, " (transitive dependency from OpenL or SLF4j dependencies)");
                continue;
            }
            String tr = (String)dependencyTrail.get(1);
            String key = tr.substring(0, tr.indexOf(58, tr.indexOf(58) + 1));
            if (!allowed.contains(key)) continue;
            this.debug("ADD : ", artifact);
            dependencies.add(artifact);
        }
        return dependencies;
    }

    private HashSet<String> getAllowedDependencies() {
        HashSet<String> allowed = new HashSet<String>();
        for (Dependency dep : this.project.getDependencies()) {
            String scope;
            String groupId = dep.getGroupId();
            String artifactId = dep.getArtifactId();
            String type = dep.getType();
            if (this.skipToProcess(groupId, type, scope = dep.getScope())) {
                this.debug("SKIP : ", dep);
                continue;
            }
            allowed.add(ArtifactUtils.versionlessKey((String)groupId, (String)artifactId));
        }
        return allowed;
    }

    private boolean skipToProcess(String groupId, String type, String scope) {
        return !this.isRuntimeScope(scope) || PackageMojo.isOpenLCoreDependency(groupId);
    }

    private boolean isRuntimeScope(String scope) {
        return "runtime".equals(scope) || "compile".equals(scope);
    }

    @Override
    String getHeader() {
        return "OPENL PACKAGING";
    }

    private File getOutputFile(File basedir, String resultFinalName, String classifier, String format) {
        Objects.requireNonNull(basedir, "basedir is not allowed to be null.");
        Objects.requireNonNull(resultFinalName, "finalName is not allowed to be null.");
        StringBuilder fileName = new StringBuilder(resultFinalName);
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            fileName.append('-').append(classifier);
        }
        fileName.append('.').append(format);
        return new File(basedir, fileName.toString());
    }

    private void unpackZip(File baseDir, String name, File zip) throws IOException {
        File outDir = new File(baseDir, name);
        ZipUtils.extractAll((File)zip, (File)outDir);
    }

    private void generateDeploymentFile(File baseDir) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", this.deploymentName);
        try (FileWriter writer = new FileWriter(new File(baseDir, DEPLOYMENT_YAML));){
            YamlMapperFactory.getYamlMapper().writeValue((Writer)writer, properties);
        }
    }

    private Manifest createManifest() {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (this.addDefaultManifest) {
            attributes.putValue("Build-Date", ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            attributes.putValue("Built-By", this.userName);
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, String.format("%s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, this.project.getVersion());
            if (this.project.getOrganization() != null) {
                attributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, this.project.getOrganization().getName());
            }
            attributes.putValue("Created-By", "OpenL Maven Plugin v" + OpenLVersion.getVersion());
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, String> entry : this.manifestEntries.entrySet()) {
                String key = entry.getKey();
                String value = StringUtils.trimToEmpty((String)entry.getValue());
                attributes.putValue(key, value);
            }
        }
        return manifest;
    }

    private String[] getExcludes() {
        ArrayList<Object> strings = new ArrayList<Object>(this.excludes.length + 2);
        Collections.addAll(strings, this.excludes);
        String targetDir = Paths.get(this.projectBaseDir, new String[0]).relativize(this.outputDirectory.toPath()) + "/**";
        strings.add(targetDir);
        strings.add("pom.xml");
        return strings.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }
}

