/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.TestResultExport;

class XlsxReportWriter {
    private final File dir;

    XlsxReportWriter(File dir) {
        this.dir = dir;
    }

    public void write(TestUnitsResults result) throws Exception {
        TestSuite testSuite = result.getTestSuite();
        String testName = testSuite.getTestSuiteMethod().getName();
        String moduleName = testSuite.getTestSuiteMethod().getModuleName();
        String suitName = "OpenL." + moduleName + "." + testName;
        String filename = "TEST-" + suitName + ".xlsx";
        if (!this.dir.mkdirs() && !this.dir.exists()) {
            throw new IOException(String.format("Cannot create folder '%s'.", this.dir.getAbsolutePath()));
        }
        File file = new File(this.dir, filename);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            new TestResultExport().export((OutputStream)outputStream, -1, new TestUnitsResults[]{result});
        }
    }
}

