/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CFHeaderRecord;
import org.apache.poi.hssf.record.CFRuleRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.ptg.AreaErrPtg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellRangeAddress;

public final class CFRecordsAggregate
extends RecordAggregate {
    private static final int MAX_CONDTIONAL_FORMAT_RULES = 3;
    private final CFHeaderRecord header;
    private final List rules;

    private CFRecordsAggregate(CFHeaderRecord pHeader, CFRuleRecord[] pRules) {
        if (pHeader == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (pRules == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (pRules.length > 3) {
            throw new IllegalArgumentException("No more than 3 rules may be specified");
        }
        if (pRules.length != pHeader.getNumberOfConditionalFormats()) {
            throw new RuntimeException("Mismatch number of rules");
        }
        this.header = pHeader;
        this.rules = new ArrayList(3);
        for (int i = 0; i < pRules.length; ++i) {
            this.rules.add(pRules[i]);
        }
    }

    public CFRecordsAggregate(CellRangeAddress[] regions, CFRuleRecord[] rules) {
        this(new CFHeaderRecord(regions, rules.length), rules);
    }

    public static CFRecordsAggregate createCFAggregate(RecordStream rs) {
        Record rec = rs.getNext();
        if (rec.getSid() != 432) {
            throw new IllegalStateException("next record sid was " + rec.getSid() + " instead of " + 432 + " as expected");
        }
        CFHeaderRecord header = (CFHeaderRecord)rec;
        int nRules = header.getNumberOfConditionalFormats();
        CFRuleRecord[] rules = new CFRuleRecord[nRules];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = (CFRuleRecord)rs.getNext();
        }
        return new CFRecordsAggregate(header, rules);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleRecord[] newRecs = new CFRuleRecord[this.rules.size()];
        for (int i = 0; i < newRecs.length; ++i) {
            newRecs[i] = (CFRuleRecord)this.getRule(i).clone();
        }
        return new CFRecordsAggregate((CFHeaderRecord)this.header.clone(), newRecs);
    }

    public CFHeaderRecord getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int idx) {
        if (idx < 0 || idx >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + idx + ") nRules=" + this.rules.size());
        }
    }

    public CFRuleRecord getRule(int idx) {
        this.checkRuleIndex(idx);
        return (CFRuleRecord)this.rules.get(idx);
    }

    public void setRule(int idx, CFRuleRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.checkRuleIndex(idx);
        this.rules.set(idx, r);
    }

    public void addRule(CFRuleRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        if (this.rules.size() >= 3) {
            throw new IllegalStateException("Cannot have more than 3 conditional format rules");
        }
        this.rules.add(r);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CF]\n");
        if (this.header != null) {
            buffer.append(this.header.toString());
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord cfRule = (CFRuleRecord)this.rules.get(i);
            buffer.append(cfRule.toString());
        }
        buffer.append("[/CF]\n");
        return buffer.toString();
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        rv.visitRecord(this.header);
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord rule = (CFRuleRecord)this.rules.get(i);
            rv.visitRecord(rule);
        }
    }

    public boolean updateFormulasAfterCellShift(FormulaShifter shifter, int currentExternSheetIx) {
        int i;
        CellRangeAddress[] cellRanges = this.header.getCellRanges();
        boolean changed = false;
        ArrayList<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
        for (i = 0; i < cellRanges.length; ++i) {
            CellRangeAddress craOld = cellRanges[i];
            CellRangeAddress craNew = CFRecordsAggregate.shiftRange(shifter, craOld, currentExternSheetIx);
            if (craNew == null) {
                changed = true;
                continue;
            }
            temp.add(craNew);
            if (craNew == craOld) continue;
            changed = true;
        }
        if (changed) {
            int nRanges = temp.size();
            if (nRanges == 0) {
                return false;
            }
            CellRangeAddress[] newRanges = new CellRangeAddress[nRanges];
            temp.toArray(newRanges);
            this.header.setCellRanges(newRanges);
        }
        for (i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord rule = (CFRuleRecord)this.rules.get(i);
            Ptg[] ptgs = rule.getParsedExpression1();
            if (ptgs != null && shifter.adjustFormula(ptgs, currentExternSheetIx)) {
                rule.setParsedExpression1(ptgs);
            }
            if ((ptgs = rule.getParsedExpression2()) == null || !shifter.adjustFormula(ptgs, currentExternSheetIx)) continue;
            rule.setParsedExpression2(ptgs);
        }
        return true;
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

