/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationSheet;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.UpdatableEvaluationCell;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;

final class HSSFEvaluationCell
implements UpdatableEvaluationCell {
    private final EvaluationSheet _evalSheet;
    private final HSSFCell _cell;

    public HSSFEvaluationCell(HSSFCell cell, EvaluationSheet evalSheet) {
        this._cell = cell;
        this._evalSheet = evalSheet;
    }

    public HSSFEvaluationCell(HSSFCell cell) {
        this(cell, new HSSFEvaluationSheet(cell.getSheet()));
    }

    @Override
    public Object getIdentityKey() {
        return this._cell;
    }

    public HSSFCell getHSSFCell() {
        return this._cell;
    }

    @Override
    public boolean getBooleanCellValue() {
        return this._cell.getBooleanCellValue();
    }

    @Override
    public int getCellType() {
        return this._cell.getCellType();
    }

    @Override
    public int getColumnIndex() {
        return this._cell.getColumnIndex();
    }

    @Override
    public int getErrorCellValue() {
        return this._cell.getErrorCellValue();
    }

    @Override
    public double getNumericCellValue() {
        return this._cell.getNumericCellValue();
    }

    @Override
    public int getRowIndex() {
        return this._cell.getRowIndex();
    }

    @Override
    public EvaluationSheet getSheet() {
        return this._evalSheet;
    }

    @Override
    public String getStringCellValue() {
        return this._cell.getRichStringCellValue().getString();
    }

    @Override
    public int getCachedFormulaResultType() {
        return this._cell.getCachedFormulaResultType();
    }

    @Override
    public boolean isArrayFormula() {
        return this._cell.isPartOfArrayFormulaGroup();
    }

    @Override
    public void setValue(ValueEval value) {
        Class<?> cls = value.getClass();
        if (cls == NumberEval.class) {
            this._cell.setCellType(0);
            this._cell.setCellValue(((NumberEval)value).getNumberValue());
            return;
        }
        if (cls == StringEval.class) {
            this._cell.setCellType(1);
            this._cell.setCellValue(((StringEval)value).getStringValue());
            return;
        }
        if (cls == BoolEval.class) {
            this._cell.setCellType(4);
            this._cell.setCellValue(((BoolEval)value).getBooleanValue());
            return;
        }
        if (cls == ErrorEval.class) {
            this._cell.setCellType(5);
            this._cell.setCellValue(((ErrorEval)value).getErrorCode());
            return;
        }
        if (cls == BlankEval.class) {
            this._cell.setCellType(3);
            return;
        }
        throw new IllegalArgumentException("Unexpected value class (" + cls.getName() + ")");
    }
}

