/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.nio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.poi.poifs.nio.DataSource;
import org.apache.poi.util.IOUtils;

public class FileBackedDataSource
extends DataSource {
    private FileChannel channel;

    public FileBackedDataSource(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.channel = new RandomAccessFile(file, "r").getChannel();
    }

    public FileBackedDataSource(FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public ByteBuffer read(int length, long position) throws IOException {
        if (position >= this.size()) {
            throw new IllegalArgumentException("Position " + position + " past the end of the file");
        }
        this.channel.position(position);
        ByteBuffer dst = ByteBuffer.allocate(length);
        int worked = IOUtils.readFully(this.channel, dst);
        if (worked == -1) {
            throw new IllegalArgumentException("Position " + position + " past the end of the file");
        }
        dst.position(0);
        return dst;
    }

    @Override
    public void write(ByteBuffer src, long position) throws IOException {
        this.channel.write(src, position);
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        WritableByteChannel out = Channels.newChannel(stream);
        this.channel.transferTo(0L, this.channel.size(), out);
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

