/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyFactory;
import org.apache.poi.poifs.property.PropertyTableBase;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class NPropertyTable
extends PropertyTableBase {
    private static final POILogger _logger = POILogFactory.getLogger(NPropertyTable.class);
    private POIFSBigBlockSize _bigBigBlockSize;

    public NPropertyTable(HeaderBlock headerBlock) {
        super(headerBlock);
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    public NPropertyTable(HeaderBlock headerBlock, NPOIFSFileSystem filesystem) throws IOException {
        super(headerBlock, NPropertyTable.buildProperties(new NPOIFSStream(filesystem, headerBlock.getPropertyStart()).iterator(), headerBlock.getBigBlockSize()));
        this._bigBigBlockSize = headerBlock.getBigBlockSize();
    }

    private static List<Property> buildProperties(Iterator<ByteBuffer> dataSource, POIFSBigBlockSize bigBlockSize) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (dataSource.hasNext()) {
            byte[] data;
            ByteBuffer bb = dataSource.next();
            if (bb.hasArray() && bb.arrayOffset() == 0 && bb.array().length == bigBlockSize.getBigBlockSize()) {
                data = bb.array();
            } else {
                data = new byte[bigBlockSize.getBigBlockSize()];
                int toRead = data.length;
                if (bb.remaining() < bigBlockSize.getBigBlockSize()) {
                    _logger.log(POILogger.WARN, (Object)"Short Property Block, ", (Object)bb.remaining(), " bytes instead of the expected " + bigBlockSize.getBigBlockSize());
                    toRead = bb.remaining();
                }
                bb.get(data, 0, toRead);
            }
            PropertyFactory.convertToProperties(data, properties);
        }
        return properties;
    }

    @Override
    public int countBlocks() {
        int size = this._properties.size() * 128;
        return (int)Math.ceil(size / this._bigBigBlockSize.getBigBlockSize());
    }

    public void write(NPOIFSStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Property property : this._properties) {
            if (property == null) continue;
            property.writeData(baos);
        }
        stream.updateContents(baos.toByteArray());
        if (this.getStartBlock() != stream.getStartBlock()) {
            this.setStartBlock(stream.getStartBlock());
        }
    }
}

