/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.formula.DefaultExternalWorkbookResolver;
import org.apache.poi.ss.formula.EvaluationCache;
import org.apache.poi.ss.formula.IEvaluationListener;
import org.apache.poi.ss.formula.IExternalWorkbookResolver;
import org.apache.poi.ss.formula.WorkbookEvaluator;

public final class CollaboratingWorkbooksEnvironment {
    public static final CollaboratingWorkbooksEnvironment EMPTY = new CollaboratingWorkbooksEnvironment();
    private final Map<String, WorkbookEvaluator> _evaluatorsByName;
    private WorkbookEvaluator[] _evaluators;
    private IExternalWorkbookResolver externalWorkbookResolver = DefaultExternalWorkbookResolver.instance;
    private boolean _unhooked;

    private CollaboratingWorkbooksEnvironment() {
        this._evaluatorsByName = Collections.emptyMap();
        this._evaluators = new WorkbookEvaluator[0];
    }

    public static CollaboratingWorkbooksEnvironment setup(String[] workbookNames, WorkbookEvaluator[] evaluators) {
        int nItems = workbookNames.length;
        if (evaluators.length != nItems) {
            throw new IllegalArgumentException("Number of workbook names is " + nItems + " but number of evaluators is " + evaluators.length);
        }
        if (nItems < 1) {
            throw new IllegalArgumentException("Must provide at least one collaborating worbook");
        }
        return new CollaboratingWorkbooksEnvironment(workbookNames, evaluators, nItems);
    }

    private CollaboratingWorkbooksEnvironment(String[] workbookNames, WorkbookEvaluator[] evaluators, int nItems) {
        HashMap<String, WorkbookEvaluator> m = new HashMap<String, WorkbookEvaluator>(nItems * 3 / 2);
        IdentityHashMap<WorkbookEvaluator, String> uniqueEvals = new IdentityHashMap<WorkbookEvaluator, String>(nItems * 3 / 2);
        for (int i = 0; i < nItems; ++i) {
            String wbName = workbookNames[i];
            WorkbookEvaluator wbEval = evaluators[i];
            if (m.containsKey(wbName)) {
                throw new IllegalArgumentException("Duplicate workbook name '" + wbName + "'");
            }
            if (uniqueEvals.containsKey(wbEval)) {
                String msg = "Attempted to register same workbook under names '" + (String)uniqueEvals.get(wbEval) + "' and '" + wbName + "'";
                throw new IllegalArgumentException(msg);
            }
            uniqueEvals.put(wbEval, wbName);
            m.put(wbName, wbEval);
        }
        this.unhookOldEnvironments(evaluators);
        CollaboratingWorkbooksEnvironment.hookNewEnvironment(evaluators, this);
        this._unhooked = false;
        this._evaluators = evaluators;
        this._evaluatorsByName = m;
    }

    private static void hookNewEnvironment(WorkbookEvaluator[] evaluators, CollaboratingWorkbooksEnvironment env) {
        int nItems = evaluators.length;
        IEvaluationListener evalListener = evaluators[0].getEvaluationListener();
        for (int i = 0; i < nItems; ++i) {
            if (evalListener == evaluators[i].getEvaluationListener()) continue;
            throw new RuntimeException("Workbook evaluators must all have the same evaluation listener");
        }
        EvaluationCache cache = new EvaluationCache(evalListener);
        for (int i = 0; i < nItems; ++i) {
            evaluators[i].attachToEnvironment(env, cache, i);
        }
    }

    private void unhookOldEnvironments(WorkbookEvaluator[] evaluators) {
        HashSet<CollaboratingWorkbooksEnvironment> oldEnvs = new HashSet<CollaboratingWorkbooksEnvironment>();
        for (int i = 0; i < evaluators.length; ++i) {
            oldEnvs.add(evaluators[i].getEnvironment());
        }
        CollaboratingWorkbooksEnvironment[] oldCWEs = new CollaboratingWorkbooksEnvironment[oldEnvs.size()];
        oldEnvs.toArray(oldCWEs);
        for (int i = 0; i < oldCWEs.length; ++i) {
            oldCWEs[i].unhook();
        }
    }

    public void dispose() {
        this.unhookOldEnvironments(this._evaluators);
    }

    private void unhook() {
        if (this._evaluators.length < 1) {
            return;
        }
        for (int i = 0; i < this._evaluators.length; ++i) {
            this._evaluators[i].detachFromEnvironment();
        }
        this._unhooked = true;
    }

    public WorkbookEvaluator getWorkbookEvaluator(String workbookName) throws WorkbookNotFoundException {
        if (this._unhooked) {
            throw new IllegalStateException("This environment has been unhooked");
        }
        WorkbookEvaluator result = this._evaluatorsByName.get(workbookName);
        if (result == null) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Could not resolve external workbook name '").append(workbookName).append("'.");
            if (this._evaluators.length < 1) {
                sb.append(" Workbook environment has not been set up.");
            } else {
                sb.append(" The following workbook names are valid: (");
                Iterator<String> i = this._evaluatorsByName.keySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    if (count++ > 0) {
                        sb.append(", ");
                    }
                    sb.append("'").append(i.next()).append("'");
                }
                sb.append(")");
            }
            throw new WorkbookNotFoundException(sb.toString());
        }
        return result;
    }

    public void addWorkbookEvaluator(String workbookName, WorkbookEvaluator evaluator) {
        this.validateWorkbookEvaluator(workbookName, evaluator);
        this._evaluatorsByName.put(workbookName, evaluator);
        WorkbookEvaluator[] _newEvaluators = new WorkbookEvaluator[this._evaluators.length + 1];
        System.arraycopy(this._evaluators, 0, _newEvaluators, 0, this._evaluators.length);
        _newEvaluators[this._evaluators.length] = evaluator;
        this._evaluators = _newEvaluators;
        CollaboratingWorkbooksEnvironment.hookNewEnvironment(this._evaluators, this);
    }

    private void validateWorkbookEvaluator(String workbookName, WorkbookEvaluator evaluator) {
        IdentityHashMap<String, WorkbookEvaluator> uniqueEvals = new IdentityHashMap<String, WorkbookEvaluator>(this._evaluatorsByName);
        if (this._evaluatorsByName.containsKey(workbookName)) {
            throw new IllegalArgumentException("Duplicate workbook name '" + workbookName + "'");
        }
        if (uniqueEvals.containsValue(evaluator)) {
            String msg = "Attempted to register same workbook under different name '" + workbookName + "'";
            throw new IllegalArgumentException(msg);
        }
    }

    public IExternalWorkbookResolver getExternalWorkbookResolver() {
        return this.externalWorkbookResolver;
    }

    public void setExternalWorkbookResolver(IExternalWorkbookResolver externalWorkbookResolver) {
        this.externalWorkbookResolver = externalWorkbookResolver;
    }

    public void resetExternalWorkbookResolver() {
        this.externalWorkbookResolver = DefaultExternalWorkbookResolver.instance;
    }

    public static final class WorkbookNotFoundException
    extends Exception {
        WorkbookNotFoundException(String msg) {
            super(msg);
        }

        WorkbookNotFoundException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

