/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.formula.LazyAreaEval;
import org.apache.poi.ss.formula.SheetRefEvaluator;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.RefEvalBase;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.AreaI;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.util.CellReference;

final class LazyRefEval
extends RefEvalBase {
    private final SheetRefEvaluator _evaluator;

    @Override
    public String getSheetName() {
        return this._evaluator.getSheetName();
    }

    public LazyRefEval(int rowIndex, int columnIndex, SheetRefEvaluator sre) {
        super(rowIndex, columnIndex);
        if (sre == null) {
            throw new IllegalArgumentException("sre must not be null");
        }
        this._evaluator = sre;
    }

    public LazyRefEval(RefPtg ptg, SheetRefEvaluator sre) {
        this(ptg.getRow(), ptg.getColumn(), sre);
    }

    public LazyRefEval(Ref3DPtg ptg, SheetRefEvaluator sre) {
        this(ptg.getRow(), ptg.getColumn(), sre);
    }

    @Override
    public ValueEval getInnerValueEval() {
        return this._evaluator.getEvalForCell(this.getRow(), this.getColumn());
    }

    @Override
    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        AreaI.OffsetArea area = new AreaI.OffsetArea(this.getRow(), this.getColumn(), relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        return new LazyAreaEval(area, this._evaluator);
    }

    public String toString() {
        CellReference cr = new CellReference(this.getRow(), this.getColumn());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append(this._evaluator.getSheetName());
        sb.append('!');
        sb.append(cr.formatAsString());
        sb.append("]");
        return sb.toString();
    }
}

