/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayMode;
import org.apache.poi.ss.formula.functions.Function0Arg;
import org.apache.poi.ss.formula.functions.Function1Arg;

public final class Column
implements Function0Arg,
Function1Arg,
ArrayMode {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex) {
        return new NumberEval(srcColumnIndex + 1);
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        int rnum;
        if (arg0 instanceof AreaEval) {
            rnum = ((AreaEval)arg0).getFirstColumn();
        } else if (arg0 instanceof RefEval) {
            rnum = ((RefEval)arg0).getColumn();
        } else {
            return ErrorEval.VALUE_INVALID;
        }
        return new NumberEval(rnum + 1);
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        switch (args.length) {
            case 1: {
                return this.evaluate(srcRowIndex, srcColumnIndex, args[0]);
            }
            case 0: {
                return new NumberEval(srcColumnIndex + 1);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    @Override
    public ValueEval evaluateInArrayFormula(ValueEval[] evals, int srcCellRow, int srcCellCol) {
        if (evals.length == 1 && evals[0] instanceof AreaEval) {
            AreaEval ae = (AreaEval)evals[0];
            ValueEval[][] result = new ValueEval[1][ae.getWidth()];
            for (int c = 0; c < ae.getWidth(); ++c) {
                result[0][c] = new NumberEval(ae.getFirstColumn() + c + 1);
            }
            return new ArrayEval(result);
        }
        return this.evaluate(evals, srcCellRow, srcCellCol);
    }
}

