/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.streaming.SheetDataWriter;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class SXSSFSheet
implements Sheet,
Cloneable {
    SXSSFWorkbook _workbook;
    XSSFSheet _sh;
    TreeMap<Integer, SXSSFRow> _rows = new TreeMap();
    SheetDataWriter _writer;
    int _randomAccessWindowSize = 100;
    int outlineLevelRow = 0;

    public SXSSFSheet(SXSSFWorkbook workbook, XSSFSheet xSheet) throws IOException {
        this._workbook = workbook;
        this._sh = xSheet;
        this._writer = workbook.createSheetDataWriter();
        this.setRandomAccessWindowSize(this._workbook.getRandomAccessWindowSize());
    }

    SheetDataWriter getSheetDataWriter() {
        return this._writer;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        this.flushRows(0);
        this._writer.close();
        return this._writer.getWorksheetXMLInputStream();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public Row createRow(int rownum) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rownum < 0 || rownum > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rownum + ") outside allowable range (0.." + maxrow + ")");
        }
        Row previousRow = rownum > 0 ? this.getRow(rownum - 1) : null;
        int initialAllocationSize = 0;
        if (previousRow != null) {
            initialAllocationSize = previousRow.getLastCellNum();
        }
        if (initialAllocationSize <= 0 && this._writer.getNumberOfFlushedRows() > 0) {
            initialAllocationSize = this._writer.getNumberOfCellsOfLastFlushedRow();
        }
        if (initialAllocationSize <= 0) {
            initialAllocationSize = 10;
        }
        SXSSFRow newRow = new SXSSFRow(this, initialAllocationSize);
        this._rows.put(new Integer(rownum), newRow);
        if (this._randomAccessWindowSize >= 0 && this._rows.size() > this._randomAccessWindowSize) {
            try {
                this.flushRows(this._randomAccessWindowSize);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return newRow;
    }

    @Override
    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        Iterator<Map.Entry<Integer, SXSSFRow>> iter = this._rows.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, SXSSFRow> entry = iter.next();
            if (entry.getValue() != row) continue;
            iter.remove();
            return;
        }
    }

    @Override
    public Row getRow(int rownum) {
        return this._rows.get(new Integer(rownum));
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size() + this._writer.getNumberOfFlushedRows();
    }

    @Override
    public int getFirstRowNum() {
        if (this._writer.getNumberOfFlushedRows() > 0) {
            return this._writer.getLowestIndexOfFlushedRows();
        }
        return this._rows.size() == 0 ? 0 : this._rows.firstKey();
    }

    @Override
    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.lastKey();
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sh.setColumnHidden(columnIndex, hidden);
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return this._sh.isColumnHidden(columnIndex);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        this._sh.setColumnWidth(columnIndex, width);
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this._sh.getColumnWidth(columnIndex);
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this._sh.setDefaultColumnWidth(width);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._sh.getDefaultColumnWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return this._sh.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return this._sh.getDefaultRowHeightInPoints();
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this._sh.setDefaultRowHeight(height);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        this._sh.setDefaultRowHeightInPoints(height);
    }

    @Override
    public CellStyle getColumnStyle(int column) {
        return this._sh.getColumnStyle(column);
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        return this._sh.addMergedRegion(region);
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        this._sh.setVerticallyCenter(value);
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        this._sh.setHorizontallyCenter(value);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this._sh.getHorizontallyCenter();
    }

    @Override
    public boolean getVerticallyCenter() {
        return this._sh.getVerticallyCenter();
    }

    @Override
    public void removeMergedRegion(int index) {
        this._sh.removeMergedRegion(index);
    }

    @Override
    public int getNumMergedRegions() {
        return this._sh.getNumMergedRegions();
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        return this._sh.getMergedRegion(index);
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this._rows.values().iterator();
        return result;
    }

    @Override
    public void setAutobreaks(boolean value) {
        this._sh.setAutobreaks(value);
    }

    @Override
    public void setDisplayGuts(boolean value) {
        this._sh.setDisplayGuts(value);
    }

    @Override
    public void setDisplayZeros(boolean value) {
        this._sh.setDisplayZeros(value);
    }

    @Override
    public boolean isDisplayZeros() {
        return this._sh.isDisplayZeros();
    }

    @Override
    public void setRightToLeft(boolean value) {
        this._sh.setRightToLeft(value);
    }

    @Override
    public boolean isRightToLeft() {
        return this._sh.isRightToLeft();
    }

    @Override
    public void setFitToPage(boolean value) {
        this._sh.setFitToPage(value);
    }

    @Override
    public void setRowSumsBelow(boolean value) {
        this._sh.setRowSumsBelow(value);
    }

    @Override
    public void setRowSumsRight(boolean value) {
        this._sh.setRowSumsRight(value);
    }

    @Override
    public boolean getAutobreaks() {
        return this._sh.getAutobreaks();
    }

    @Override
    public boolean getDisplayGuts() {
        return this._sh.getDisplayGuts();
    }

    @Override
    public boolean getFitToPage() {
        return this._sh.getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return this._sh.getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return this._sh.getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this._sh.isPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean show) {
        this._sh.setPrintGridlines(show);
    }

    @Override
    public PrintSetup getPrintSetup() {
        return this._sh.getPrintSetup();
    }

    @Override
    public Header getHeader() {
        return this._sh.getHeader();
    }

    @Override
    public Footer getFooter() {
        return this._sh.getFooter();
    }

    @Override
    public void setSelected(boolean value) {
        this._sh.setSelected(value);
    }

    @Override
    public double getMargin(short margin) {
        return this._sh.getMargin(margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        this._sh.setMargin(margin, size);
    }

    @Override
    public boolean getProtect() {
        return this._sh.getProtect();
    }

    @Override
    public void protectSheet(String password) {
        this._sh.protectSheet(password);
    }

    @Override
    public boolean getScenarioProtect() {
        return this._sh.getScenarioProtect();
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        this._sh.setZoom(numerator, denominator);
    }

    @Override
    public short getTopRow() {
        return this._sh.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this._sh.getLeftCol();
    }

    @Override
    public void showInPane(short toprow, short leftcol) {
        this._sh.showInPane(toprow, leftcol);
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        this._sh.setForceFormulaRecalculation(value);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._sh.getForceFormulaRecalculation();
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this._sh.createFreezePane(colSplit, rowSplit, leftmostColumn, topRow);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this._sh.createFreezePane(colSplit, rowSplit);
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this._sh.createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this._sh.getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this._sh.setDisplayGridlines(show);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this._sh.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this._sh.setDisplayFormulas(show);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this._sh.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this._sh.setDisplayRowColHeadings(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this._sh.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int row) {
        this._sh.setRowBreak(row);
    }

    @Override
    public boolean isRowBroken(int row) {
        return this._sh.isRowBroken(row);
    }

    @Override
    public void removeRowBreak(int row) {
        this._sh.removeRowBreak(row);
    }

    @Override
    public int[] getRowBreaks() {
        return this._sh.getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this._sh.getColumnBreaks();
    }

    @Override
    public void setColumnBreak(int column) {
        this._sh.setColumnBreak(column);
    }

    @Override
    public boolean isColumnBroken(int column) {
        return this._sh.isColumnBroken(column);
    }

    @Override
    public void removeColumnBreak(int column) {
        this._sh.removeColumnBreak(column);
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sh.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this._sh.groupColumn(fromColumn, toColumn);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sh.ungroupColumn(fromColumn, toColumn);
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        CTSheetFormatPr pr;
        for (SXSSFRow row : this._rows.subMap(fromRow, toRow + 1).values()) {
            int level = row.getOutlineLevel() + 1;
            row.setOutlineLevel(level);
            if (level <= this.outlineLevelRow) continue;
            this.outlineLevelRow = level;
        }
        CTWorksheet ct = this._sh.getCTWorksheet();
        CTSheetFormatPr cTSheetFormatPr = pr = ct.isSetSheetFormatPr() ? ct.getSheetFormatPr() : ct.addNewSheetFormatPr();
        if (this.outlineLevelRow > 0) {
            pr.setOutlineLevelRow((short)this.outlineLevelRow);
        }
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        this._sh.ungroupRow(fromRow, toRow);
    }

    @Override
    public void setRowGroupCollapsed(int row, boolean collapse) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sh.setDefaultColumnStyle(column, style);
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
        }
    }

    @Override
    public Comment getCellComment(int row, int column) {
        return this._sh.getCellComment(row, column);
    }

    @Override
    public Drawing createDrawingPatriarch() {
        return this._sh.createDrawingPatriarch();
    }

    @Override
    public Workbook getWorkbook() {
        return this._workbook;
    }

    @Override
    public String getSheetName() {
        return this._sh.getSheetName();
    }

    @Override
    public boolean isSelected() {
        return this._sh.isSelected();
    }

    @Override
    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        return this._sh.setArrayFormula(formula, range);
    }

    @Override
    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return this._sh.removeArrayFormula(cell);
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return this._sh.getDataValidationHelper();
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        this._sh.addValidationData(dataValidation);
    }

    @Override
    public AutoFilter setAutoFilter(CellRangeAddress range) {
        return this._sh.setAutoFilter(range);
    }

    @Override
    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return this._sh.getSheetConditionalFormatting();
    }

    public void setRandomAccessWindowSize(int value) {
        if (value == 0 || value < -1) {
            throw new IllegalArgumentException("RandomAccessWindowSize must be either -1 or a positive integer");
        }
        this._randomAccessWindowSize = value;
    }

    public void flushRows(int remaining) throws IOException {
        while (this._rows.size() > remaining) {
            this.flushOneRow();
        }
    }

    public void flushRows() throws IOException {
        this.flushRows(0);
    }

    private void flushOneRow() throws IOException {
        Integer firstRowNum = this._rows.firstKey();
        if (firstRowNum != null) {
            int rowIndex = firstRowNum;
            SXSSFRow row = this._rows.get(firstRowNum);
            this._writer.writeRow(rowIndex, row);
            this._rows.remove(firstRowNum);
        }
    }

    public void changeRowNum(SXSSFRow row, int newRowNum) {
        this.removeRow(row);
        this._rows.put(new Integer(newRowNum), row);
    }

    public int getRowNum(SXSSFRow row) {
        for (Map.Entry<Integer, SXSSFRow> entry : this._rows.entrySet()) {
            if (entry.getValue() != row) continue;
            return entry.getKey();
        }
        assert (false);
        return -1;
    }
}

