/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.BorderFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class XSSFBorderFormatting
implements BorderFormatting {
    CTBorder _border;

    XSSFBorderFormatting(CTBorder border) {
        this._border = border;
    }

    @Override
    public short getBorderBottom() {
        STBorderStyle.Enum ptrn = this._border.isSetBottom() ? this._border.getBottom().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    @Override
    public short getBorderDiagonal() {
        STBorderStyle.Enum ptrn = this._border.isSetDiagonal() ? this._border.getDiagonal().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    @Override
    public short getBorderLeft() {
        STBorderStyle.Enum ptrn = this._border.isSetLeft() ? this._border.getLeft().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    @Override
    public short getBorderRight() {
        STBorderStyle.Enum ptrn = this._border.isSetRight() ? this._border.getRight().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    @Override
    public short getBorderTop() {
        STBorderStyle.Enum ptrn = this._border.isSetTop() ? this._border.getTop().getStyle() : null;
        return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
    }

    @Override
    public short getBottomBorderColor() {
        if (!this._border.isSetBottom()) {
            return 0;
        }
        CTBorderPr pr = this._border.getBottom();
        return (short)pr.getColor().getIndexed();
    }

    @Override
    public short getDiagonalBorderColor() {
        if (!this._border.isSetDiagonal()) {
            return 0;
        }
        CTBorderPr pr = this._border.getDiagonal();
        return (short)pr.getColor().getIndexed();
    }

    @Override
    public short getLeftBorderColor() {
        if (!this._border.isSetLeft()) {
            return 0;
        }
        CTBorderPr pr = this._border.getLeft();
        return (short)pr.getColor().getIndexed();
    }

    @Override
    public short getRightBorderColor() {
        if (!this._border.isSetRight()) {
            return 0;
        }
        CTBorderPr pr = this._border.getRight();
        return (short)pr.getColor().getIndexed();
    }

    @Override
    public short getTopBorderColor() {
        if (!this._border.isSetTop()) {
            return 0;
        }
        CTBorderPr pr = this._border.getTop();
        return (short)pr.getColor().getIndexed();
    }

    @Override
    public void setBorderBottom(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetBottom() ? this._border.getBottom() : this._border.addNewBottom();
        if (border == 0) {
            this._border.unsetBottom();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
    }

    @Override
    public void setBorderDiagonal(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetDiagonal() ? this._border.getDiagonal() : this._border.addNewDiagonal();
        if (border == 0) {
            this._border.unsetDiagonal();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
    }

    @Override
    public void setBorderLeft(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetLeft() ? this._border.getLeft() : this._border.addNewLeft();
        if (border == 0) {
            this._border.unsetLeft();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
    }

    @Override
    public void setBorderRight(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetRight() ? this._border.getRight() : this._border.addNewRight();
        if (border == 0) {
            this._border.unsetRight();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
    }

    @Override
    public void setBorderTop(short border) {
        CTBorderPr pr;
        CTBorderPr cTBorderPr = pr = this._border.isSetTop() ? this._border.getTop() : this._border.addNewTop();
        if (border == 0) {
            this._border.unsetTop();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
    }

    @Override
    public void setBottomBorderColor(short color) {
        CTBorderPr pr = this._border.isSetBottom() ? this._border.getBottom() : this._border.addNewBottom();
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed((long)color);
        pr.setColor(ctColor);
    }

    @Override
    public void setDiagonalBorderColor(short color) {
        CTBorderPr pr = this._border.isSetDiagonal() ? this._border.getDiagonal() : this._border.addNewDiagonal();
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed((long)color);
        pr.setColor(ctColor);
    }

    @Override
    public void setLeftBorderColor(short color) {
        CTBorderPr pr = this._border.isSetLeft() ? this._border.getLeft() : this._border.addNewLeft();
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed((long)color);
        pr.setColor(ctColor);
    }

    @Override
    public void setRightBorderColor(short color) {
        CTBorderPr pr = this._border.isSetRight() ? this._border.getRight() : this._border.addNewRight();
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed((long)color);
        pr.setColor(ctColor);
    }

    @Override
    public void setTopBorderColor(short color) {
        CTBorderPr pr = this._border.isSetTop() ? this._border.getTop() : this._border.addNewTop();
        CTColor ctColor = CTColor.Factory.newInstance();
        ctColor.setIndexed((long)color);
        pr.setColor(ctColor);
    }
}

