/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calculation.result.convertor2;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.result.SpreadsheetResultHelper;
import org.openl.rules.calculation.result.convertor2.CalculationStep;
import org.openl.rules.calculation.result.convertor2.ColumnToExtract;
import org.openl.rules.calculation.result.convertor2.CompoundStep;
import org.openl.rules.calculation.result.convertor2.NestedSpreadsheetConfiguration;
import org.openl.rules.calculation.result.convertor2.RowExtractor;
import org.openl.rules.calculation.result.convertor2.RowFilter;
import org.openl.rules.calculation.result.convertor2.SpreadsheetColumnExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NestedSpreadsheetResultConverter<T extends CalculationStep, Q extends CompoundStep> {
    private static final Logger LOG = LoggerFactory.getLogger(NestedSpreadsheetResultConverter.class);
    private final NestedSpreadsheetConfiguration<T, Q> conf;
    private final int currentNestingLevel;

    public NestedSpreadsheetResultConverter(int currentNestingLevel, NestedSpreadsheetConfiguration<T, Q> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be empty");
        }
        this.conf = configuration;
        this.currentNestingLevel = currentNestingLevel;
    }

    public List<CalculationStep> process(SpreadsheetResult spreadsheetResult) {
        ArrayList<CalculationStep> steps = new ArrayList<CalculationStep>();
        if (spreadsheetResult != null) {
            int height = spreadsheetResult.getHeight();
            RowFilter rowFilter = this.conf.buildRowFilter();
            for (int row = 0; row < height; ++row) {
                CalculationStep step;
                if (rowFilter != null && rowFilter.excludeRow(spreadsheetResult.getRowName(row)) || (step = this.processRow(spreadsheetResult, row)) == null) continue;
                steps.add(step);
            }
            return steps;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Spreadsheet result is null.");
        }
        return steps;
    }

    private CalculationStep processRow(SpreadsheetResult spreadsheetResult, int row) {
        RowExtractor<Object> rowExtractor;
        Object valueInColumn;
        int columnIndex;
        List<ColumnToExtract> confCompoundColumns = this.conf.getColumnsToExtract(this.currentNestingLevel);
        ArrayList<ColumnToExtract> compoundColumns = new ArrayList<ColumnToExtract>();
        ArrayList extractors = new ArrayList();
        for (ColumnToExtract column : confCompoundColumns) {
            int columnIndex2 = SpreadsheetResultHelper.getColumnIndex(column.getColumnName(), spreadsheetResult.getColumnNames());
            if (columnIndex2 >= 0) {
                compoundColumns.add(column);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Column {} has been skipped.", (Object)column.getColumnName());
        }
        boolean isNestedRow = false;
        int minNestedPriority = -1;
        for (ColumnToExtract column : compoundColumns) {
            columnIndex = SpreadsheetResultHelper.getColumnIndexByName(column.getColumnName(), spreadsheetResult.getColumnNames());
            valueInColumn = spreadsheetResult.getValue(row, columnIndex);
            if (!NestedSpreadsheetResultConverter.valueIsNested(valueInColumn) || column.getNestedPriority() <= 0 || column.getNestedPriority() > minNestedPriority && minNestedPriority != -1) continue;
            minNestedPriority = column.getNestedPriority();
        }
        for (ColumnToExtract column : compoundColumns) {
            columnIndex = SpreadsheetResultHelper.getColumnIndexByName(column.getColumnName(), spreadsheetResult.getColumnNames());
            valueInColumn = spreadsheetResult.getValue(row, columnIndex);
            if (!isNestedRow && minNestedPriority > 0 && minNestedPriority == column.getNestedPriority() && NestedSpreadsheetResultConverter.valueIsNested(valueInColumn)) {
                extractors.add(this.conf.initCompoundColumnExtractor(this.currentNestingLevel, column));
                isNestedRow = true;
                continue;
            }
            extractors.add(new SpreadsheetColumnExtractor(column, this.conf));
        }
        if (isNestedRow) {
            rowExtractor = this.conf.initCompoundRowExtractor(extractors);
            rowExtractor.setConf(this.conf);
        } else {
            ArrayList simpleExtractors = new ArrayList();
            for (ColumnToExtract column : compoundColumns) {
                simpleExtractors.add(new SpreadsheetColumnExtractor(column, this.conf));
            }
            rowExtractor = this.conf.initSimpleRowExtractor(simpleExtractors);
            rowExtractor.setConf(this.conf);
        }
        Q step = rowExtractor.extract(spreadsheetResult, row);
        return step;
    }

    private static boolean valueIsNested(Object value) {
        return value instanceof SpreadsheetResult || value instanceof SpreadsheetResult[];
    }
}

