/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calculation.result.convertor2;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.result.SpreadsheetResultHelper;
import org.openl.rules.calculation.result.convertor2.CalculationStep;
import org.openl.rules.calculation.result.convertor2.CompoundStep;
import org.openl.rules.calculation.result.convertor2.ConvertationMetadata;
import org.openl.rules.calculation.result.convertor2.NestedSpreadsheetConfiguration;
import org.openl.rules.calculation.result.convertor2.SpreadsheetColumnExtractor;

@Deprecated
public abstract class RowExtractor<T extends CalculationStep> {
    private final List<SpreadsheetColumnExtractor<T>> columnExtractors;
    private NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> conf;

    public RowExtractor(List<SpreadsheetColumnExtractor<T>> columnExtractors) {
        this.columnExtractors = columnExtractors == null ? new CopyOnWriteArrayList<SpreadsheetColumnExtractor<T>>() : new CopyOnWriteArrayList<SpreadsheetColumnExtractor<T>>(columnExtractors);
    }

    public NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> getConf() {
        return this.conf;
    }

    public void setConf(NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> conf) {
        this.conf = conf;
    }

    protected abstract T makeRowInstance();

    protected abstract T afterExtract(T var1);

    public final T extract(SpreadsheetResult spreadsheetResult, int rowIndex) {
        T rowInstance = this.makeRowInstance();
        ConvertationMetadata convertationMetadata = null;
        if (this.getConf() != null && this.getConf().isConvertationMetadataEnabled()) {
            convertationMetadata = new ConvertationMetadata();
            convertationMetadata.setSpreadsheetResult(spreadsheetResult);
        }
        for (SpreadsheetColumnExtractor<T> extractor : this.columnExtractors) {
            String columnName = extractor.getColumn().getColumnName();
            int columnIndex = SpreadsheetResultHelper.getColumnIndexByName(columnName, spreadsheetResult.getColumnNames());
            Object columnValue = spreadsheetResult.getValue(rowIndex, columnIndex);
            Object v = extractor.convertAndStoreData(columnValue, rowInstance);
            if (convertationMetadata == null || v == null) continue;
            if (v instanceof ConvertationMetadata.NestedType) {
                ConvertationMetadata.NestedType nestedType = (ConvertationMetadata.NestedType)((Object)v);
                convertationMetadata.setNestedMetadata(nestedType, rowIndex, columnIndex);
                continue;
            }
            if (!(v instanceof String)) continue;
            convertationMetadata.addPropertyMetadata((String)v, rowIndex, columnIndex);
        }
        ((CalculationStep)rowInstance).setStepName(spreadsheetResult.getRowName(rowIndex));
        rowInstance = this.afterExtract(rowInstance);
        if (convertationMetadata != null) {
            ((CalculationStep)rowInstance).setConvertationMetadata(convertationMetadata);
        }
        return rowInstance;
    }
}

