/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calculation.result.convertor2;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.openl.binding.impl.cast.IArrayOneElementCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.calculation.result.convertor2.CalculationStep;
import org.openl.rules.calculation.result.convertor2.ColumnToExtract;
import org.openl.rules.calculation.result.convertor2.CompoundStep;
import org.openl.rules.calculation.result.convertor2.NestedSpreadsheetConfiguration;
import org.openl.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpreadsheetColumnExtractor<S extends CalculationStep> {
    private static final Logger LOG = LoggerFactory.getLogger(SpreadsheetColumnExtractor.class);
    private final NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> conf;
    private ColumnToExtract column;

    public SpreadsheetColumnExtractor(ColumnToExtract column, NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> configuration) {
        this.column = column;
        this.conf = configuration;
    }

    public NestedSpreadsheetConfiguration<? extends CalculationStep, ? extends CompoundStep> getConfiguration() {
        return this.conf;
    }

    public ColumnToExtract getColumn() {
        return this.column;
    }

    public void setColumn(ColumnToExtract column) {
        this.column = column;
    }

    public Object convertAndStoreData(Object valueForStoraging, S step) {
        if (valueForStoraging != null) {
            String[] propertyNames = this.column.getPropertyNames();
            Class<?>[] expectedTypes = this.column.getExpectedTypes();
            IOpenCast theBestCast = null;
            Class type = Object.class;
            String propertyName = null;
            int minConvertDistance = Integer.MAX_VALUE;
            for (int i = 0; i < expectedTypes.length; ++i) {
                Class<?> expectedType = expectedTypes[i];
                IOpenCast openCast = this.getConfiguration().getObjectToDataOpenCastConvertor().getConvertor(valueForStoraging.getClass(), expectedType);
                if (openCast == null || openCast.getDistance() >= minConvertDistance) continue;
                theBestCast = openCast;
                minConvertDistance = openCast.getDistance();
                type = expectedType;
                propertyName = propertyNames[i];
            }
            if (theBestCast != null) {
                int arrLength;
                if (theBestCast instanceof IArrayOneElementCast && (arrLength = Array.getLength(valueForStoraging)) != 1) {
                    return null;
                }
                Object value = theBestCast.convert(valueForStoraging);
                if (this.store(value, step, propertyName, type)) {
                    return propertyName;
                }
            }
        }
        return null;
    }

    private boolean store(Object value, S step, String propertyName, Class<?> expectedType) {
        Method setterMethod = this.getSetterMethod(step, propertyName, expectedType);
        if (setterMethod != null) {
            try {
                setterMethod.invoke(step, value);
                return true;
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Cannot find setter in class '{}' for [{}] column", (Object)step.getClass().getName(), (Object)this.column.getColumnName());
        }
        return false;
    }

    private Method getSetterMethod(S step, String propertyName, Class<?> expectedType) {
        Method setterMethod = null;
        String setterName = ClassUtils.setter((String)propertyName);
        try {
            setterMethod = step.getClass().getMethod(setterName, expectedType);
        }
        catch (Exception e) {
            try {
                setterName = this.getSetterName(propertyName);
                setterMethod = step.getClass().getMethod(setterName, expectedType);
            }
            catch (Exception e1) {
                LOG.warn(e1.getMessage(), (Throwable)e1);
            }
        }
        return setterMethod;
    }

    protected String getSetterName(String fieldName) {
        return String.format("set%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1).toLowerCase());
    }
}

