package org.openl.ie.constrainer;

///////////////////////////////////////////////////////////////////////////////
/*
 * Copyright Exigen Group 1998, 1999, 2000
 * 320 Amboy Ave., Metuchen, NJ, 08840, USA, www.exigengroup.com
 *
 * The copyright to the computer program(s) herein
 * is the property of Exigen Group, USA. All rights reserved.
 * The program(s) may be used and/or copied only with
 * the written permission of Exigen Group
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */
///////////////////////////////////////////////////////////////////////////////

//
//: Failure.java
//
/**
 * Class Failure implements a special exception generated by Constrainer when some goals/constraints fail.
 *
 * @see Goal#execute()
 */
public class Failure extends Exception {
    private String _msg;
    private ChoicePointLabel _label = null;

    /**
     * Constructor for a Failure with no description.
     */
    public Failure() {
        this("");
    }

    /**
     * Constructor for a Failure with a given description.
     */
    public Failure(String s) {
        super(s);
        _msg = s;
        // System.out.println("FAIL: "+this);
    }

    /**
     * Constructor for a Failure with a given description and label.
     */
    public Failure(String s, ChoicePointLabel label) {
        super(s);
        _msg = s;
        _label = label;
        // System.out.println("FAIL: "+this);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    /**
     * Returns the failure label.
     */
    public ChoicePointLabel label() {
        return _label;
    }

    /**
     * Returns the failure description.
     */
    @Override
    public String toString() {
        return "Failure: " + _msg;
    }

} // ~Failure
