/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Queue;
import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ExpressionFactory;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolVar;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.UndoableInt;
import org.openl.ie.constrainer.impl.ExpressionFactoryImpl;
import org.openl.ie.constrainer.impl.GoalStack;
import org.openl.ie.constrainer.impl.IntBoolVarImpl;
import org.openl.ie.constrainer.impl.IntVarImpl;
import org.openl.ie.constrainer.impl.UndoFastVectorAdd;
import org.openl.ie.constrainer.impl.UndoStack;
import org.openl.ie.constrainer.impl.UndoableIntImpl;
import org.openl.ie.constrainer.impl.UndoableOnceImpl;
import org.openl.ie.tools.FastStack;
import org.openl.ie.tools.FastVector;

public final class Constrainer
implements Serializable {
    public static double FLOAT_PRECISION = 1.0E-6;
    private final String _name;
    private final FastVector _intvars;
    private final FastVector _constraints;
    private final int _choice_point;
    private GoalStack _goal_stack;
    private final UndoStack _reversibility_stack;
    private int _number_of_choice_points;
    private int _number_of_failures;
    private int _number_of_undos;
    private final FastVector _choice_point_objects;
    private final FastVector _failure_objects;
    private final boolean _trace_failure_stack;
    private final int _failure_display_frequency;
    private final FastVector _backtrack_objects;
    private final boolean _trace_goals;
    private boolean _show_internal_names;
    private final boolean _show_variable_names;
    private final long _initial_memory;
    private long _max_occupied_memory;
    private long _number_of_notifications;
    private final boolean _print_information;
    private long _execution_time = 0L;
    private final Queue _propagation_queue;
    private final ExpressionFactory _expressionFactory;
    private final FastStack _active_undoable_once;
    private transient PrintStream _out = System.out;

    public static void abort(String msg) {
        throw new RuntimeException(msg);
    }

    public static double precision() {
        return FLOAT_PRECISION;
    }

    public static void precision(double prc) {
        FLOAT_PRECISION = prc;
    }

    static void printObjects(PrintStream out, String prefix, FastVector objects) {
        int size = objects.size();
        Object[] data = objects.data();
        for (int i = 0; i < size; ++i) {
            out.print(prefix);
            out.println(data[i]);
        }
    }

    public Constrainer(String s) {
        this._max_occupied_memory = this._initial_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this._name = s;
        this._active_undoable_once = new FastStack();
        this._intvars = new FastVector();
        this._constraints = new FastVector();
        this._reversibility_stack = new UndoStack();
        this._goal_stack = new GoalStack(this._reversibility_stack);
        this._propagation_queue = new ArrayDeque();
        this._show_internal_names = false;
        this._show_variable_names = true;
        this._choice_point = 0;
        this._number_of_choice_points = 0;
        this._number_of_failures = 0;
        this._number_of_notifications = 0L;
        this._failure_display_frequency = 0;
        this._number_of_undos = 0;
        this._choice_point_objects = new FastVector();
        this._failure_objects = new FastVector();
        this._backtrack_objects = new FastVector();
        this._trace_goals = false;
        this._trace_failure_stack = false;
        this._print_information = false;
        this._expressionFactory = new ExpressionFactoryImpl(this);
    }

    IntBoolVar addIntBoolVar(IntBoolVar var) {
        this._intvars.add(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    public IntBoolVar addIntBoolVar(String name) {
        IntBoolVarImpl var = new IntBoolVarImpl(this, name);
        return this.addIntBoolVar(var);
    }

    public IntVar addIntVar(int min, int max) {
        return this.addIntVar(min, max, "", -1);
    }

    public IntVar addIntVar(int min, int max, int type) {
        return this.addIntVar(min, max, "", type);
    }

    public IntVar addIntVar(int min, int max, String name) {
        return this.addIntVar(min, max, name, -1);
    }

    public IntVar addIntVar(int min, int max, String name, int type) {
        IntVarImpl var = new IntVarImpl(this, min, max, name, type);
        return this.addIntVar(var);
    }

    IntVar addIntVar(IntVar var) {
        this._intvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    IntVar addIntVarInternal(IntVar var) {
        this._intvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    public IntVar addIntVarTraceInternal(int min, int max, String name, int type) {
        IntVarImpl var = new IntVarImpl(this, min, max, name, type);
        return this.addIntVarInternal(var);
    }

    public void addToPropagationQueue(Subject subject) {
        this._propagation_queue.add(subject);
    }

    public void addUndo(Undo undo_object) {
        ++this._number_of_undos;
        this._reversibility_stack.pushUndo(undo_object);
    }

    public void addUndo(Undo undo_object, Undoable undoable) {
        this.addUndo(undo_object);
        if (undoable instanceof UndoableOnceImpl) {
            this._active_undoable_once.push(undoable);
        }
    }

    public UndoableInt addUndoableInt(int value) {
        return new UndoableIntImpl(this, value);
    }

    void allowUndos() {
        while (!this._active_undoable_once.empty()) {
            ((UndoableOnceImpl)this._active_undoable_once.pop()).restore();
        }
    }

    boolean backtrack(ChoicePointLabel label) {
        boolean success = this._goal_stack.backtrack(label);
        this.allowUndos();
        if (success && this._backtrack_objects.size() > 0) {
            Constrainer.printObjects(this._out, "BACKTRACK: ", this._backtrack_objects);
        }
        return success;
    }

    public int getStackSize() {
        return this._reversibility_stack.size();
    }

    public void backtrackStack(int newSize) {
        this._reversibility_stack.backtrack(newSize);
    }

    void clearPropagationQueue() {
        while (!this._propagation_queue.isEmpty()) {
            Subject var = (Subject)this._propagation_queue.remove();
            var.inProcess(false);
        }
    }

    public FastVector constraints() {
        return this._constraints;
    }

    void doPrintInformation() {
        this._out.println("\nChoice Points: " + this._number_of_choice_points + "  Failures: " + this._number_of_failures + "  Undos: " + this._number_of_undos + "  Notifications: " + this._number_of_notifications + "  Memory: " + (this._max_occupied_memory - this._initial_memory) + "  Time: " + this._execution_time + "msec");
    }

    public boolean execute(Goal goal) {
        return this.execute(goal, false);
    }

    public synchronized boolean execute(Goal main_goal, boolean restore_flag) {
        boolean restoreAnyway;
        long execution_start = System.currentTimeMillis();
        boolean success = true;
        GoalStack old_goal_stack = this._goal_stack;
        this._goal_stack = new GoalStack(main_goal, this._reversibility_stack);
        this.allowUndos();
        while (!this._goal_stack.empty()) {
            long occupied_memory;
            try {
                Goal goal = this._goal_stack.popGoal();
                if (this._trace_goals) {
                    this._out.println("Execute: " + goal);
                }
                goal = goal.execute();
                this.propagate();
                if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                    this._max_occupied_memory = occupied_memory;
                }
                if (goal == null) continue;
                this._goal_stack.pushGoal(goal);
            }
            catch (Failure f) {
                if (this._trace_failure_stack && this._failure_display_frequency > 0 && this._number_of_failures % this._failure_display_frequency == 0) {
                    f.printStackTrace(this._out);
                }
                if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                    this._max_occupied_memory = occupied_memory;
                }
                this.clearPropagationQueue();
                if (this.backtrack(f.label())) continue;
                success = false;
                break;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception t) {
                throw new RuntimeException("Unexpected exception: ", t);
            }
        }
        boolean bl = restoreAnyway = restore_flag || !success;
        if (restoreAnyway) {
            this.backtrackStack(this._goal_stack.undoStackSize());
        }
        this._execution_time += System.currentTimeMillis() - execution_start;
        if (this._print_information && !(main_goal instanceof Constraint)) {
            this.doPrintInformation();
        }
        this._goal_stack = old_goal_stack;
        return success;
    }

    public ExpressionFactory expressionFactory() {
        return this._expressionFactory;
    }

    public void fail(String s) throws Failure {
        ++this._number_of_failures;
        if (this._failure_display_frequency > 0 && this._number_of_failures % this._failure_display_frequency == 0) {
            this._out.println("Failure " + this._number_of_failures + ": " + s);
        }
        if (this._failure_display_frequency == 0 || this._number_of_failures % this._failure_display_frequency == 0) {
            for (int i = 0; i < this._failure_objects.size(); ++i) {
                this._out.println("Failure: " + s + " " + this._failure_objects.elementAt(i));
            }
        }
        throw new Failure(s);
    }

    public void incrementNumberOfNotifications() {
        ++this._number_of_notifications;
    }

    public void propagate() throws Failure {
        while (!this._propagation_queue.isEmpty()) {
            Subject var = (Subject)this._propagation_queue.remove();
            var.inProcess(false);
            var.propagate();
        }
    }

    void pushOnExecutionStack(Goal goal) {
        this._goal_stack.pushGoal(goal);
    }

    void setChoicePoint(Goal g1, Goal g2, ChoicePointLabel label) {
        ++this._number_of_choice_points;
        this._goal_stack.setChoicePoint(g1, g2, label);
        this.allowUndos();
        if (this._choice_point_objects.size() > 0) {
            Constrainer.printObjects(this._out, "CP " + (this._choice_point - 1) + ":", this._choice_point_objects);
        }
    }

    public boolean showInternalNames() {
        return this._show_internal_names;
    }

    public void showInternalNames(boolean flag) {
        this._show_internal_names = flag;
    }

    public boolean showVariableNames() {
        return this._show_variable_names;
    }

    public String toString() {
        return "Constrainer: " + this._name + "\n" + this._goal_stack + "\n" + this._reversibility_stack;
    }
}

