/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.consistencyChecking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.consistencyChecking.DTChecker;

public class Overlapping {
    private List<Integer> _overlapped = null;
    protected String[] _solutionNames;
    protected int[] _solutionValues;
    private OverlappingStatus status;

    public OverlappingStatus getStatus() {
        return this.status;
    }

    Overlapping(IntExpArray solution) {
        this._solutionNames = DTChecker.Utils.IntExpArray2Names(solution);
        this._solutionValues = DTChecker.Utils.IntExpArray2Values(solution);
    }

    Overlapping(Overlapping ovl, int i, int j, OverlappingStatus status) {
        this.status = status;
        this._solutionNames = ovl.getSolutionNames();
        this._solutionValues = ovl.getSolutionValues();
        this.addRule(i);
        this.addRule(j);
    }

    void addRule(int num) {
        if (this._overlapped == null) {
            this._overlapped = new ArrayList<Integer>();
        }
        this._overlapped.add(num);
    }

    public int amount() {
        return this._overlapped.size();
    }

    public int[] getOverlapped() {
        int[] arr = new int[this._overlapped.size()];
        Iterator<Integer> iter = this._overlapped.iterator();
        int i = 0;
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    public Map<String, Integer> getSolution() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this._solutionNames.length; ++i) {
            map.put(this._solutionNames[i], this._solutionValues[i]);
        }
        return map;
    }

    public String[] getSolutionNames() {
        return this._solutionNames;
    }

    public int[] getSolutionValues() {
        return this._solutionValues;
    }

    public String toString() {
        return "{ solution: " + this.getSolution() + " obeys the following rules: " + this._overlapped + "}";
    }

    public static enum OverlappingStatus {
        BLOCK(1),
        PARTIAL(2),
        OVERRIDE(4);

        private final int bit;

        private OverlappingStatus(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }
    }
}

