/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OpenAPIRefResolver {
    private final Map<String, Object> resolvedByRefCache = new HashMap<String, Object>();
    private final OpenAPI openAPI;

    public OpenAPIRefResolver(OpenAPI openAPI) {
        this.openAPI = Objects.requireNonNull(openAPI, "openAPI cannot be null");
    }

    public Object resolve(String ref) {
        return this.resolveByRef(ref, () -> {});
    }

    public <T> T resolve(T obj, Function<T, String> getRefFunc) {
        return this.resolve(obj, getRefFunc, () -> {});
    }

    public <T> T resolve(T obj, Function<T, String> getRefFunc, Runnable retNotFoundFunc) {
        if (obj != null && getRefFunc.apply(obj) != null) {
            return (T)this.resolve(this.resolveByRef(getRefFunc.apply(obj), retNotFoundFunc), getRefFunc);
        }
        return obj;
    }

    private Object resolveByRef(String ref, Runnable retNotFoundFunc) {
        if (this.resolvedByRefCache.containsKey(ref)) {
            return this.resolvedByRefCache.get(ref);
        }
        String expression = ref.substring(1);
        String[] expressionParts = expression.split("(?=/)");
        Object resolvedByRef = this.openAPI;
        try {
            for (String expressionPart : Arrays.stream(expressionParts).map(e -> e.substring(1)).collect(Collectors.toList())) {
                if (resolvedByRef == null) continue;
                try {
                    Field field = resolvedByRef.getClass().getDeclaredField(expressionPart);
                    field.setAccessible(true);
                    resolvedByRef = field.get(resolvedByRef);
                }
                catch (NoSuchFieldException | SecurityException e2) {
                    if (Map.class.isAssignableFrom(resolvedByRef.getClass())) {
                        resolvedByRef = ((Map)resolvedByRef).get(expressionPart);
                        continue;
                    }
                    resolvedByRef = null;
                }
                catch (IllegalAccessException e3) {
                    resolvedByRef = null;
                }
            }
        }
        catch (Exception e4) {
            resolvedByRef = null;
        }
        if (resolvedByRef != this.openAPI && resolvedByRef != null) {
            this.resolvedByRefCache.put(ref, resolvedByRef);
            return resolvedByRef;
        }
        this.resolvedByRefCache.put(ref, null);
        retNotFoundFunc.run();
        return null;
    }
}

