/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.validation.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openl.rules.project.openapi.OpenAPIRefResolver;
import org.openl.rules.project.validation.openapi.Context;
import org.openl.rules.project.validation.openapi.OpenApiProjectValidatorMessagesUtils;

final class OpenAPIResolver {
    private final OpenAPIRefResolver openAPIRefResolver;
    private final Context context;
    private final Map<Schema, Map<String, Schema>> allPropertiesCache = new IdentityHashMap<Schema, Map<String, Schema>>();

    public OpenAPIResolver(Context context, OpenAPI openAPI) {
        this.context = Objects.requireNonNull(context, "context cannot be null");
        this.openAPIRefResolver = new OpenAPIRefResolver(Objects.requireNonNull(openAPI, "openAPI cannot be null"));
    }

    public <T> T resolve(T obj, Function<T, String> getRefFunc) {
        return (T)this.openAPIRefResolver.resolve(obj, getRefFunc, () -> {
            if (this.context.isTypeValidationInProgress()) {
                OpenApiProjectValidatorMessagesUtils.addTypeError(this.context, String.format("Invalid $ref '%s' is used in the OpenAPI file.", getRefFunc.apply(obj)));
            } else {
                OpenApiProjectValidatorMessagesUtils.addMethodError(this.context, String.format("Invalid $ref '%s' is used in the OpenAPI file.", getRefFunc.apply(obj)));
            }
        });
    }

    public Map<String, Schema> resolveAllProperties(Schema<?> schema) {
        Map allSchemaProperties = this.allPropertiesCache.get(schema);
        if (allSchemaProperties != null) {
            return allSchemaProperties;
        }
        Schema resolvedSchema = this.resolve(schema, Schema::get$ref);
        if (resolvedSchema != null) {
            ComposedSchema composedSchema;
            allSchemaProperties = new HashMap<String, Schema>();
            if (resolvedSchema instanceof ComposedSchema && (composedSchema = (ComposedSchema)resolvedSchema).getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
                for (Schema embeddedSchema : composedSchema.getAllOf()) {
                    Map<String, Schema> embeddedSchemaProperties = this.resolveAllProperties(embeddedSchema);
                    if (embeddedSchemaProperties == null) continue;
                    allSchemaProperties.putAll(embeddedSchemaProperties);
                }
            }
            if (resolvedSchema.getProperties() != null) {
                allSchemaProperties.putAll(resolvedSchema.getProperties());
            }
            if (resolvedSchema != schema) {
                this.allPropertiesCache.put(resolvedSchema, allSchemaProperties);
            }
        } else {
            allSchemaProperties = schema.getProperties() != null ? schema.getProperties() : Collections.emptyMap();
        }
        this.allPropertiesCache.put(schema, allSchemaProperties);
        return allSchemaProperties;
    }
}

