/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.validation.openapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Objects;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.openapi.OpenAPIConfiguration;
import org.openl.rules.project.validation.openapi.Context;
import org.openl.rules.project.validation.openapi.SpreadsheetMethodResolver;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidatedCompiledOpenClass;

final class OpenApiProjectValidatorMessagesUtils {
    private OpenApiProjectValidatorMessagesUtils() {
    }

    private static void addError(Context context, String summary) {
        ValidatedCompiledOpenClass validatedCompiledOpenClass = context.getValidatedCompiledOpenClass();
        if (OpenApiProjectValidatorMessagesUtils.isNotExistingError(validatedCompiledOpenClass, summary)) {
            validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)summary));
        }
    }

    private static boolean isNotExistingError(ValidatedCompiledOpenClass validatedCompiledOpenClass, String summary) {
        for (OpenLMessage openLMessage : validatedCompiledOpenClass.getAllMessages()) {
            if (!openLMessage.isError() || !Objects.equals(openLMessage.getSummary(), summary)) continue;
            return false;
        }
        return true;
    }

    public static void addMethodError(Context context, String summary) {
        OpenApiProjectValidatorMessagesUtils.addMethodError(context, context.getOpenMethod(), summary);
    }

    private static void addMethodError(Context context, IOpenMethod method, String summary) {
        if (method instanceof OpenMethodDispatcher) {
            OpenMethodDispatcher openMethodDispatcher = (OpenMethodDispatcher)method;
            for (IOpenMethod m : openMethodDispatcher.getCandidates()) {
                if (context.getField() != null && m instanceof Spreadsheet && m.getType() instanceof CustomSpreadsheetResultOpenClass) {
                    IOpenField openFieldInSpr = SpreadsheetMethodResolver.findSpreadsheetOpenField((Spreadsheet)m, context.getField());
                    if (openFieldInSpr == null) continue;
                    if (context.getIsIncompatibleTypesPredicate() != null) {
                        Class<Object> instanceClass = openFieldInSpr.getType() instanceof SpreadsheetResultOpenClass && ((SpreadsheetResultOpenClass)openFieldInSpr.getType()).getModule() != null ? ((SpreadsheetResultOpenClass)openFieldInSpr.getType()).toCustomSpreadsheetResultOpenClass().getBeanClass() : (openFieldInSpr.getType() instanceof CustomSpreadsheetResultOpenClass ? ((CustomSpreadsheetResultOpenClass)openFieldInSpr.getType()).getBeanClass() : openFieldInSpr.getType().getInstanceClass());
                        if (instanceClass == null) {
                            instanceClass = Object.class;
                        }
                        ModelConverterContextImpl openAPIContext = new ModelConverterContextImpl(OpenAPIConfiguration.getConverters((ObjectMapper)context.getObjectMapper()));
                        Schema actualSchema = openAPIContext.resolve(new AnnotatedType().type(instanceClass));
                        if (!context.getIsIncompatibleTypesPredicate().test(actualSchema, openFieldInSpr)) continue;
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, m, summary);
                        continue;
                    }
                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, m, summary);
                    continue;
                }
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, m, summary);
            }
        } else {
            TableSyntaxNode tableSyntaxNode = OpenApiProjectValidatorMessagesUtils.extractTableSyntaxNode(method);
            if (tableSyntaxNode != null) {
                SyntaxNodeException syntaxNodeException = SyntaxNodeExceptionUtils.createError((String)summary, (ISyntaxNode)tableSyntaxNode);
                if (OpenApiProjectValidatorMessagesUtils.isNotExistingError(context.getValidatedCompiledOpenClass(), summary)) {
                    OpenLMessage openLMessage = OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)syntaxNodeException);
                    context.getValidatedCompiledOpenClass().addMessage(openLMessage);
                }
            } else {
                OpenApiProjectValidatorMessagesUtils.addError(context, summary);
            }
        }
    }

    private static IOpenClass findOpenClass(Context context) {
        for (IOpenClass openClass : context.getOpenClass().getTypes()) {
            if (!Objects.equals(context.getType().getInstanceClass(), openClass.getInstanceClass())) continue;
            return openClass;
        }
        return context.getType();
    }

    public static void addTypeError(Context context, String summary) {
        IOpenClass type = OpenApiProjectValidatorMessagesUtils.findOpenClass(context);
        if (type instanceof DatatypeOpenClass) {
            DatatypeOpenClass datatypeOpenClass = (DatatypeOpenClass)type;
            if (datatypeOpenClass.getTableSyntaxNode() != null) {
                SyntaxNodeException syntaxNodeException = SyntaxNodeExceptionUtils.createError((String)summary, (ISyntaxNode)datatypeOpenClass.getTableSyntaxNode());
                if (OpenApiProjectValidatorMessagesUtils.isNotExistingError(context.getValidatedCompiledOpenClass(), summary)) {
                    OpenLMessage openLMessage = OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)syntaxNodeException);
                    context.getValidatedCompiledOpenClass().addMessage(openLMessage);
                }
            }
        } else {
            IOpenMethod method = context.getSpreadsheetMethodResolver().resolve(type);
            if (method != null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, method, summary);
            } else {
                OpenApiProjectValidatorMessagesUtils.addError(context, summary);
            }
        }
    }

    private static TableSyntaxNode extractTableSyntaxNode(IOpenMethod method) {
        if (method instanceof ExecutableRulesMethod) {
            ExecutableRulesMethod executableRulesMethod = (ExecutableRulesMethod)method;
            return executableRulesMethod.getSyntaxNode();
        }
        return null;
    }

    public static void addMethodWarning(Context context, String summary) {
        ValidatedCompiledOpenClass compiledOpenClass = context.getValidatedCompiledOpenClass();
        compiledOpenClass.getAllMessages().stream().filter(x -> x.getSeverity().equals((Object)Severity.WARN)).filter(x -> Objects.equals(x.getSummary(), summary)).findFirst().ifPresentOrElse(x -> {}, () -> OpenApiProjectValidatorMessagesUtils.addWarn(summary, compiledOpenClass, context));
    }

    private static void addWarn(String summary, ValidatedCompiledOpenClass compiledOpenClass, Context context) {
        TableSyntaxNode tsn = OpenApiProjectValidatorMessagesUtils.extractTableSyntaxNode(context.getOpenMethod());
        OpenLMessage message = tsn == null ? OpenLMessagesUtils.newWarnMessage((String)summary) : OpenLMessagesUtils.newWarnMessage((String)summary, (ISyntaxNode)tsn);
        compiledOpenClass.addMessage(message);
    }
}

