/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.validation.openapi;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.project.validation.openapi.Context;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;

class OpenClassPropertiesResolver {
    private final Context context;
    private final Map<IOpenClass, Map<String, IOpenField>> cache = new HashMap<IOpenClass, Map<String, IOpenField>>();

    public OpenClassPropertiesResolver(Context context) {
        this.context = Objects.requireNonNull(context, "context cannot be null");
    }

    private IOpenField resolveOpenFieldByPropertyName(IOpenClass openClass, String propertyName) {
        BeanPropertyDefinition beanPropertyDefinition = this.resolveOpenBeanPropertyDefinitionByPropertyName(openClass, propertyName);
        if (beanPropertyDefinition != null) {
            String fieldName;
            if (beanPropertyDefinition.getAccessor() instanceof AnnotatedField) {
                fieldName = beanPropertyDefinition.getAccessor().getName();
            } else {
                String getterName = beanPropertyDefinition.getAccessor().getName();
                fieldName = ClassUtils.toFieldName((String)getterName);
            }
            IOpenField openField = openClass.getField(fieldName);
            if (openField != null) {
                return openField;
            }
            openField = openClass.getField(ClassUtils.capitalize((String)fieldName));
            if (openField != null) {
                return openField;
            }
            return openClass.getField(StringUtils.uncapitalize((String)fieldName));
        }
        return null;
    }

    private BeanPropertyDefinition resolveOpenBeanPropertyDefinitionByPropertyName(IOpenClass openClass, String propertyName) {
        BeanDescription beanDesc = this.context.getObjectMapper().getSerializationConfig().introspect(TypeFactory.defaultInstance().constructType((Type)openClass.getInstanceClass()));
        for (BeanPropertyDefinition beanPropertyDefinition : beanDesc.findProperties()) {
            if (!Objects.equals(propertyName, beanPropertyDefinition.getName())) continue;
            return beanPropertyDefinition;
        }
        return null;
    }

    public IOpenField findFieldByPropertyName(IOpenClass openClass, String propertyName) {
        Map propertiesCache = this.cache.computeIfAbsent(openClass, e -> new HashMap());
        return propertiesCache.computeIfAbsent(propertyName, e -> this.resolveOpenFieldByPropertyName(openClass, (String)e));
    }
}

