/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openl.OpenClassUtil;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.AmbiguousDependencyException;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.DependencyNotFoundException;
import org.openl.dependency.DependencyType;
import org.openl.dependency.IDependencyManager;
import org.openl.dependency.ResolvedDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.project.instantiation.IDependencyLoader;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDependencyDescriptor;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDependencyManager
implements IDependencyManager {
    private static final Pattern ASTERISK_SIGN = Pattern.compile("\\*");
    private static final Pattern QUESTION_SIGN = Pattern.compile("\\?");
    private static final Pattern SLASH_SIGN = Pattern.compile("\\s*/\\s*");
    private final Logger log = LoggerFactory.getLogger(AbstractDependencyManager.class);
    private volatile CopyOnWriteArraySet<IDependencyLoader> dependencyLoaders;
    private final Object dependencyLoadersFlag = new Object();
    private final LinkedHashSet<DependencyRelation> dependencyRelations = new LinkedHashSet();
    private final ThreadLocal<Deque<IDependencyLoader>> compilationStackThreadLocal = ThreadLocal.withInitial(ArrayDeque::new);
    private final Map<ProjectDescriptor, ClassLoader> externalJarsClassloaders = new HashMap<ProjectDescriptor, ClassLoader>();
    private final ClassLoader rootClassLoader;
    protected boolean executionMode;
    private Map<String, Object> externalParameters;

    public static ResolvedDependency buildResolvedDependency(String projectName) {
        return AbstractDependencyManager.buildResolvedDependency(projectName, null);
    }

    public static ResolvedDependency buildResolvedDependency(String projectName, String moduleName) {
        if (moduleName == null) {
            return new ResolvedDependency(DependencyType.PROJECT, new IdentifierNode(null, null, projectName, null));
        }
        return new ResolvedDependency(DependencyType.MODULE, new IdentifierNode(null, null, projectName + "/" + moduleName, null));
    }

    public static ResolvedDependency buildResolvedDependency(ProjectDescriptor project) {
        return new ResolvedDependency(DependencyType.PROJECT, new IdentifierNode(null, null, project.getName(), null));
    }

    public static ResolvedDependency buildResolvedDependency(Module module) {
        return AbstractDependencyManager.buildResolvedDependency(module.getProject().getName(), module.getName());
    }

    protected AbstractDependencyManager(ClassLoader rootClassLoader, boolean executionMode, Map<String, Object> externalParameters) {
        this.rootClassLoader = rootClassLoader;
        this.executionMode = executionMode;
        this.externalParameters = new HashMap<String, Object>();
        if (externalParameters != null) {
            this.externalParameters.putAll(externalParameters);
        }
        this.externalParameters = Collections.unmodifiableMap(this.externalParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependencyLoaders(Collection<IDependencyLoader> dependencyLoadersToAdd) {
        if (dependencyLoadersToAdd != null) {
            Object object = this.dependencyLoadersFlag;
            synchronized (object) {
                this.dependencyLoaders.addAll(dependencyLoadersToAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IDependencyLoader> getDependencyLoaders() {
        if (this.dependencyLoaders == null) {
            AbstractDependencyManager abstractDependencyManager = this;
            synchronized (abstractDependencyManager) {
                if (this.dependencyLoaders == null) {
                    this.dependencyLoaders = new CopyOnWriteArraySet<IDependencyLoader>(this.initDependencyLoaders());
                }
            }
        }
        return Collections.unmodifiableSet(this.dependencyLoaders);
    }

    protected abstract Set<IDependencyLoader> initDependencyLoaders();

    private Deque<IDependencyLoader> getCompilationStack() {
        return this.compilationStackThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompiledDependency loadDependency(ResolvedDependency dependency) throws OpenLCompilationException {
        IDependencyLoader dependencyLoader = this.findDependencyLoaderByDependency(dependency);
        Deque<IDependencyLoader> compilationStack = this.getCompilationStack();
        try {
            CompiledDependency compiledDependency;
            boolean isCircularDependency;
            if (this.log.isDebugEnabled()) {
                this.log.debug(compilationStack.contains(dependencyLoader) ? "Dependency '{}' in the compilation stack." : "Dependency '{}' is not found in the compilation stack.", (Object)dependency);
            }
            if (!(isCircularDependency = compilationStack.contains(dependencyLoader)) && !compilationStack.isEmpty()) {
                DependencyRelation dr = new DependencyRelation(this.getCompilationStack().getFirst(), dependencyLoader);
                this.addDependencyRelation(dr);
            }
            if (isCircularDependency) {
                throw new OpenLCompilationException(String.format("Circular dependency is detected: %s.", AbstractDependencyManager.buildCircularDependencyDetails(dependencyLoader, compilationStack)), null, dependency.getNode().getSourceLocation(), dependency.getNode().getModule());
            }
            try {
                compilationStack.push(dependencyLoader);
                this.log.debug("Dependency '{}' is added to the compilation stack.", (Object)dependencyLoader.getDependency());
                compiledDependency = dependencyLoader.getCompiledDependency();
            }
            finally {
                compilationStack.poll();
                this.log.debug("Dependency '{}' is removed from the compilation stack.", (Object)dependencyLoader.getDependency());
            }
            if (compiledDependency == null) {
                CompiledDependency compiledDependency2 = this.throwDependencyNotFoundError((IDependency)dependency);
                return compiledDependency2;
            }
            CompiledDependency compiledDependency3 = compiledDependency;
            return compiledDependency3;
        }
        finally {
            if (compilationStack.isEmpty()) {
                this.compilationStackThreadLocal.remove();
            }
        }
    }

    public IDependencyLoader findDependencyLoader(ResolvedDependency dependency) {
        return this.getDependencyLoaders().stream().filter(e -> DependencyType.ANY.equals((Object)dependency.getType()) ? Objects.equals(dependency.getNode(), e.getDependency().getNode()) : Objects.equals(dependency, e.getDependency())).findFirst().orElse(null);
    }

    public Collection<IDependencyLoader> findAllProjectDependencyLoaders(ProjectDescriptor project) {
        HashSet<IDependencyLoader> dependencyLoadersForProject = new HashSet<IDependencyLoader>();
        ArrayDeque<ProjectDescriptor> queue = new ArrayDeque<ProjectDescriptor>();
        queue.add(project);
        HashSet<ProjectDescriptor> projectDescriptors = new HashSet<ProjectDescriptor>();
        while (!queue.isEmpty()) {
            ProjectDescriptor projectDescriptor = (ProjectDescriptor)queue.poll();
            this.getDependencyLoaders().stream().filter(e -> Objects.equals(e.getProject(), projectDescriptor)).forEach(dependencyLoadersForProject::add);
            if (projectDescriptor.getDependencies() == null) continue;
            for (ProjectDependencyDescriptor pdd : projectDescriptor.getDependencies()) {
                IDependencyLoader dl = this.findDependencyLoader(AbstractDependencyManager.buildResolvedDependency(pdd.getName()));
                if (dl == null || !dl.isProjectLoader() || projectDescriptors.contains(dl.getProject())) continue;
                queue.add(dl.getProject());
                projectDescriptors.add(dl.getProject());
            }
        }
        return dependencyLoadersForProject;
    }

    public Collection<ResolvedDependency> resolveDependency(IDependency dependency, boolean withWildcardSupport) throws AmbiguousDependencyException, DependencyNotFoundException {
        Collection<IDependencyLoader> visibleDependencyLoaders;
        boolean withWildcard;
        Object value = dependency.getNode().getIdentifier();
        if (withWildcardSupport) {
            withWildcard = ASTERISK_SIGN.matcher((CharSequence)value).find() || QUESTION_SIGN.matcher((CharSequence)value).find();
            value = ASTERISK_SIGN.matcher((CharSequence)value).replaceAll("\\\\E.*\\\\Q");
            value = QUESTION_SIGN.matcher((CharSequence)value).replaceAll("\\\\E.\\\\Q");
            value = SLASH_SIGN.matcher((CharSequence)value).replaceAll("\\\\E\\\\s*/\\\\s*\\\\Q");
        } else {
            withWildcard = false;
        }
        value = "\\Q" + (String)value + "\\E";
        IDependencyLoader currentDependencyLoader = !this.getCompilationStack().isEmpty() ? this.getCompilationStack().getFirst() : null;
        Collection<IDependencyLoader> collection = visibleDependencyLoaders = currentDependencyLoader != null ? this.findAllProjectDependencyLoaders(currentDependencyLoader.getProject()) : this.getDependencyLoaders();
        if (DependencyType.PROJECT.equals((Object)dependency.getType())) {
            visibleDependencyLoaders = visibleDependencyLoaders.stream().filter(IDependencyLoader::isProjectLoader).collect(Collectors.toSet());
        } else if (DependencyType.MODULE.equals((Object)dependency.getType())) {
            visibleDependencyLoaders = visibleDependencyLoaders.stream().filter(e -> !e.isProjectLoader()).collect(Collectors.toSet());
        }
        Set<Object> dependencyLoaders = new HashSet<IDependencyLoader>();
        for (IDependencyLoader dl : visibleDependencyLoaders) {
            if (Objects.equals(currentDependencyLoader, dl) || dl.isProjectLoader() && currentDependencyLoader != null && Objects.equals(dl.getProject(), currentDependencyLoader.getProject()) || !Pattern.matches((String)value, dl.getDependency().getNode().getIdentifier())) continue;
            dependencyLoaders.add(dl);
        }
        for (IDependencyLoader dl : visibleDependencyLoaders) {
            if (dl.isProjectLoader() || dl.isProjectLoader() || Objects.equals(currentDependencyLoader, dl) || !Pattern.matches((String)value, dl.getModule().getName())) continue;
            dependencyLoaders.add(dl);
        }
        if (dependencyLoaders.stream().anyMatch(e -> !e.isProjectLoader())) {
            dependencyLoaders = dependencyLoaders.stream().filter(e -> !e.isProjectLoader()).collect(Collectors.toSet());
        }
        Collection ret = dependencyLoaders.stream().map(e -> new ResolvedDependency(e.isProjectLoader() ? DependencyType.PROJECT : DependencyType.MODULE, new IdentifierNode(dependency.getNode().getType(), dependency.getNode().getLocation(), e.getDependency().getNode().getIdentifier(), null))).collect(Collectors.toSet());
        if (!withWildcard && ret.size() != 1) {
            if (ret.isEmpty()) {
                throw new DependencyNotFoundException(String.format("Dependency '%s' is not found.", dependency.getNode().getIdentifier()), null, dependency.getNode().getSourceLocation(), dependency.getNode().getModule());
            }
            throw new AmbiguousDependencyException(String.format("Multiple dependencies '%s' are found.", dependency.getNode().getIdentifier()), null, dependency.getNode().getSourceLocation(), dependency.getNode().getModule());
        }
        return ret;
    }

    protected IDependencyLoader findDependencyLoaderByDependency(ResolvedDependency dependency) throws OpenLCompilationException {
        IDependencyLoader dependencyLoader = this.findDependencyLoader(dependency);
        if (dependencyLoader == null) {
            throw new OpenLCompilationException(String.format("Dependency '%s' is not found.", dependency.getNode().getIdentifier()), null, dependency.getNode().getSourceLocation(), dependency.getNode().getModule());
        }
        return dependencyLoader;
    }

    private static String buildCircularDependencyDetails(IDependencyLoader dependencyLoader, Deque<IDependencyLoader> compilationStack) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<Module>> p = compilationStack.stream().filter(e -> !e.isProjectLoader()).map(IDependencyLoader::getModule).collect(Collectors.groupingBy(Module::getName));
        Iterator<IDependencyLoader> itr = compilationStack.iterator();
        sb.append("'");
        sb.insert(0, (Object)(!dependencyLoader.isProjectLoader() && p.get(dependencyLoader.getModule().getName()).size() == 1 ? dependencyLoader.getModule().getName() : dependencyLoader.getDependency()));
        while (itr.hasNext()) {
            IDependencyLoader s = itr.next();
            sb.insert(0, "' -> '");
            sb.insert(0, (Object)(!s.isProjectLoader() && p.get(s.getModule().getName()).size() == 1 ? s.getModule().getName() : s.getDependency()));
            if (!Objects.equals(dependencyLoader, s)) continue;
            break;
        }
        sb.insert(0, "'");
        return sb.toString();
    }

    private CompiledDependency throwDependencyNotFoundError(IDependency dependency) throws OpenLCompilationException {
        IdentifierNode node = dependency.getNode();
        throw new OpenLCompilationException(String.format("Dependency '%s' is not found.", node.getIdentifier()), null, node.getSourceLocation(), node.getModule());
    }

    public synchronized ClassLoader getExternalJarsClassLoader(ProjectDescriptor project) {
        HashSet<ProjectDescriptor> breadcrumbs = new HashSet<ProjectDescriptor>();
        breadcrumbs.add(project);
        return this.getExternalJarsClassLoaderRec(project, breadcrumbs);
    }

    public synchronized ClassLoader getExternalJarsClassLoaderRec(ProjectDescriptor project, Set<ProjectDescriptor> breadcrumbs) {
        this.getDependencyLoaders();
        if (this.externalJarsClassloaders.get(project) != null) {
            return this.externalJarsClassloaders.get(project);
        }
        ClassLoader parentClassLoader = this.rootClassLoader == null ? this.getClass().getClassLoader() : this.rootClassLoader;
        OpenLClassLoader externalJarsClassloader = new OpenLClassLoader(project.getClassPathUrls(), parentClassLoader);
        if (project.getDependencies() != null) {
            Collection projectDependencyLoaders = this.getDependencyLoaders().stream().filter(IDependencyLoader::isProjectLoader).collect(Collectors.toCollection(ArrayList::new));
            block0: for (ProjectDependencyDescriptor projectDependencyDescriptor : project.getDependencies()) {
                for (IDependencyLoader dl : projectDependencyLoaders) {
                    if (!Objects.equals(projectDependencyDescriptor.getName(), dl.getProject().getName())) continue;
                    if (breadcrumbs.contains(dl.getProject())) continue block0;
                    breadcrumbs.add(dl.getProject());
                    externalJarsClassloader.addClassLoader(this.getExternalJarsClassLoaderRec(dl.getProject(), breadcrumbs));
                    breadcrumbs.remove(dl.getProject());
                    continue block0;
                }
            }
        }
        this.externalJarsClassloaders.put(project, (ClassLoader)externalJarsClassloader);
        return externalJarsClassloader;
    }

    public synchronized void resetOthers(ResolvedDependency ... dependencies) {
        if (dependencies == null || dependencies.length == 0) {
            return;
        }
        HashSet<IDependencyLoader> dependenciesToKeep = new HashSet<IDependencyLoader>();
        ArrayDeque<IDependencyLoader> queue = new ArrayDeque<IDependencyLoader>();
        for (ResolvedDependency dependency : dependencies) {
            if (dependency == null) continue;
            IDependencyLoader dependencyLoader = this.findDependencyLoader(dependency);
            queue.add(dependencyLoader);
            dependenciesToKeep.add(dependencyLoader);
        }
        while (!queue.isEmpty()) {
            IDependencyLoader depLoader = (IDependencyLoader)queue.poll();
            for (DependencyRelation dependencyReference : this.dependencyRelations) {
                if (!dependencyReference.getDependency().equals(depLoader) || !dependenciesToKeep.add(dependencyReference.getDependOnThisDependency())) continue;
                queue.add(dependencyReference.getDependOnThisDependency());
            }
        }
        for (IDependencyLoader depLoader : this.getDependencyLoaders()) {
            if (dependenciesToKeep.contains(depLoader)) continue;
            this.reset(depLoader.getDependency());
        }
    }

    public synchronized void reset(ResolvedDependency dependency) {
        if (dependency == null) {
            return;
        }
        IDependencyLoader dependencyLoader = this.findDependencyLoader(dependency);
        HashSet<DependencyRelation> dependenciesReferencesToRemove = new HashSet<DependencyRelation>();
        ArrayDeque<IDependencyLoader> queue = new ArrayDeque<IDependencyLoader>();
        queue.add(dependencyLoader);
        HashSet<IDependencyLoader> dependenciesToReset = new HashSet<IDependencyLoader>();
        dependenciesToReset.add(dependencyLoader);
        HashSet<ProjectDescriptor> projectClassloaderToReset = new HashSet<ProjectDescriptor>();
        while (!queue.isEmpty()) {
            CompiledDependency compiledDependency;
            IOpenClass openClass;
            IDependencyLoader depLoader = (IDependencyLoader)queue.poll();
            for (DependencyRelation dependencyReference : this.dependencyRelations) {
                if (dependencyReference.getDependOnThisDependency().equals(depLoader) && dependenciesToReset.add(dependencyReference.getDependency())) {
                    queue.add(dependencyReference.getDependency());
                }
                if (!dependencyReference.getDependency().equals(depLoader)) continue;
                dependenciesReferencesToRemove.add(dependencyReference);
            }
            if (depLoader.getRefToCompiledDependency() == null || !((openClass = (compiledDependency = depLoader.getRefToCompiledDependency()).getCompiledOpenClass().getOpenClassWithErrors()) instanceof XlsModuleOpenClass) || !((XlsModuleOpenClass)openClass).isAppliedChangesToClasspath()) continue;
            ArrayDeque<ProjectDescriptor> queue1 = new ArrayDeque<ProjectDescriptor>();
            queue1.add(dependencyLoader.getProject());
            while (!queue1.isEmpty()) {
                ProjectDescriptor pd = (ProjectDescriptor)queue1.poll();
                if (!projectClassloaderToReset.add(pd)) continue;
                for (IDependencyLoader dl : this.getDependencyLoaders()) {
                    if (Objects.equals(dl.getProject(), pd) && dependenciesToReset.add(dl)) {
                        queue.add(dl);
                    }
                    if (!dl.isProjectLoader() || dl.getProject().getDependencies() == null) continue;
                    for (ProjectDependencyDescriptor pdd : dl.getProject().getDependencies()) {
                        if (!Objects.equals(pdd.getName(), pd.getName())) continue;
                        queue1.add(dl.getProject());
                    }
                }
            }
        }
        for (IDependencyLoader dependencyToReset : dependenciesToReset) {
            if (dependencyToReset.getRefToCompiledDependency() != null) {
                this.log.debug("Dependency '{}' is reset.", (Object)dependencyToReset.getDependency());
            }
            dependencyToReset.reset();
        }
        for (DependencyRelation dependencyReference : dependenciesReferencesToRemove) {
            this.dependencyRelations.remove(dependencyReference);
        }
        for (ProjectDescriptor projectDescriptor : projectClassloaderToReset) {
            ClassLoader cl = this.externalJarsClassloaders.get(projectDescriptor);
            if (cl != null) {
                OpenClassUtil.releaseClassLoader((ClassLoader)cl);
            }
            this.externalJarsClassloaders.remove(projectDescriptor);
        }
    }

    public synchronized void resetAll() {
        for (ClassLoader classLoader : this.externalJarsClassloaders.values()) {
            OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
        }
        this.externalJarsClassloaders.clear();
        this.getDependencyLoaders().forEach(IDependencyLoader::reset);
        this.dependencyRelations.clear();
    }

    protected synchronized void addDependencyRelation(DependencyRelation dependencyRelation) {
        this.dependencyRelations.add(dependencyRelation);
    }

    public boolean isExecutionMode() {
        return this.executionMode;
    }

    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public static class DependencyRelation {
        IDependencyLoader dependOnThisDependency;
        IDependencyLoader dependency;

        public DependencyRelation(IDependencyLoader dependency, IDependencyLoader dependOnThisDependency) {
            this.dependency = dependency;
            this.dependOnThisDependency = dependOnThisDependency;
        }

        public IDependencyLoader getDependency() {
            return this.dependency;
        }

        public IDependencyLoader getDependOnThisDependency() {
            return this.dependOnThisDependency;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.dependOnThisDependency == null ? 0 : this.dependOnThisDependency.hashCode());
            result = 31 * result + (this.dependency == null ? 0 : this.dependency.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyRelation other = (DependencyRelation)obj;
            if (this.dependOnThisDependency == null ? other.dependOnThisDependency != null : !this.dependOnThisDependency.equals(other.dependOnThisDependency)) {
                return false;
            }
            if (this.dependency == null) {
                return other.dependency == null;
            }
            return this.dependency.equals(other.dependency);
        }

        public String toString() {
            return String.format("DependencyReference [dependOnThisDependency=%s, dependency=%s]", this.dependOnThisDependency.getDependency(), this.dependency.getDependency());
        }
    }
}

