/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Map;
import java.util.Objects;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.runtime.AEngineFactory;

public abstract class CommonRulesInstantiationStrategy
implements RulesInstantiationStrategy {
    private Class<?> serviceClass;
    private final boolean executionMode;
    protected ClassLoader classLoader;
    private final IDependencyManager dependencyManager;
    private Map<String, Object> externalParameters;

    public CommonRulesInstantiationStrategy(boolean executionMode, IDependencyManager dependencyManager) {
        this(executionMode, dependencyManager, null);
    }

    public CommonRulesInstantiationStrategy(boolean executionMode, IDependencyManager dependencyManager, ClassLoader classLoader) {
        this.dependencyManager = Objects.requireNonNull(dependencyManager, "dependencyManager cannot be null");
        this.executionMode = executionMode;
        this.classLoader = classLoader;
    }

    @Override
    public Object instantiate() throws RulesInstantiationException {
        return this.instantiate(false);
    }

    @Override
    public Object instantiate(boolean ignoreCompilationErrors) throws RulesInstantiationException {
        return this.instantiate(this.getInstanceClass(), ignoreCompilationErrors);
    }

    @Override
    public ClassLoader getClassLoader() throws RulesInstantiationException {
        if (this.classLoader == null) {
            this.classLoader = this.initClassLoader();
        }
        return this.classLoader;
    }

    protected abstract ClassLoader initClassLoader() throws RulesInstantiationException;

    @Override
    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public Class<?> getInstanceClass() throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            if (this.isServiceClassDefined()) {
                Class<?> clazz = this.getServiceClass();
                return clazz;
            }
            Class<?> clazz = this.getGeneratedRulesClass();
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public boolean isServiceClassDefined() {
        return this.serviceClass != null;
    }

    protected boolean isExecutionMode() {
        return this.executionMode;
    }

    protected IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    @Override
    public Class<?> getGeneratedRulesClass() throws RulesInstantiationException {
        return this.compile().getOpenClassWithErrors().getInstanceClass();
    }

    @Override
    public void reset() {
    }

    @Override
    public void forcedReset() {
        this.reset();
        this.classLoader = null;
    }

    protected abstract Object instantiate(Class<?> var1, boolean var2) throws RulesInstantiationException;

    @Override
    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    @Override
    public void setExternalParameters(Map<String, Object> parameters) {
        this.externalParameters = parameters;
    }

    @Override
    public CompiledOpenClass compile() throws RulesInstantiationException {
        return this.compileInternal(this.getEngineFactory());
    }

    protected abstract AEngineFactory getEngineFactory() throws RulesInstantiationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CompiledOpenClass compileInternal(AEngineFactory engineFactory) throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            CompiledOpenClass compiledOpenClass = engineFactory.getCompiledOpenClass();
            return compiledOpenClass;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

