/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.project.instantiation.AbstractServiceClassEnhancerInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancerHelper;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancerInvocationHandler;
import org.openl.rules.project.instantiation.ValidationServiceClassException;
import org.openl.runtime.ASMProxyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeContextInstantiationStrategyEnhancer
extends AbstractServiceClassEnhancerInstantiationStrategy {
    private final Logger log = LoggerFactory.getLogger(RuntimeContextInstantiationStrategyEnhancer.class);

    public RuntimeContextInstantiationStrategyEnhancer(RulesInstantiationStrategy instantiationStrategy) {
        super(instantiationStrategy);
    }

    @Override
    protected Class<?> decorateServiceClass(Class<?> serviceClass, ClassLoader classLoader) {
        try {
            return RuntimeContextInstantiationStrategyEnhancerHelper.decorateClass(serviceClass, classLoader);
        }
        catch (Exception e) {
            throw new OpenlNotCheckedException("Failed to add runtime context in parameters of each method.", (Throwable)e);
        }
    }

    @Override
    protected Class<?> undecorateServiceClass(Class<?> serviceClass, ClassLoader classLoader) {
        try {
            return RuntimeContextInstantiationStrategyEnhancerHelper.undecorateClass(serviceClass, classLoader);
        }
        catch (Exception e) {
            throw new OpenlNotCheckedException("Failed to remove runtime context from parameters of each method.", (Throwable)e);
        }
    }

    @Override
    protected boolean validateServiceClass(Class<?> serviceClass) throws ValidationServiceClassException {
        if (RuntimeContextInstantiationStrategyEnhancerHelper.isDecoratedClass(serviceClass)) {
            return true;
        }
        throw new ValidationServiceClassException("Runtime context parameter is required in each method.");
    }

    @Override
    protected ASMProxyHandler makeMethodHandler(Object instanceObject) throws Exception {
        Map<Method, Method> methodsMap = this.makeMethodMap(this.getServiceClass(), this.getOriginalInstantiationStrategy().getInstanceClass());
        return new RuntimeContextInstantiationStrategyEnhancerInvocationHandler(methodsMap, instanceObject);
    }

    private Map<Method, Method> makeMethodMap(Class<?> interfaceClass, Class<?> serviceClass) {
        Method[] serviceMethods;
        this.log.debug("Creating methods map for classes: {} <-> {}", interfaceClass, serviceClass);
        HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Method serviceMethod : serviceMethods = serviceClass.getDeclaredMethods()) {
            String interfaceMethodName = serviceMethod.getName();
            Object[] serviceMethodParameterTypes = serviceMethod.getParameterTypes();
            Object[] newParams = new Class[]{IRulesRuntimeContext.class};
            Class[] extendedParamTypes = (Class[])ArrayUtils.addAll((Object[])newParams, (Object[])serviceMethodParameterTypes);
            try {
                Method interfaceMethod = interfaceClass.getMethod(interfaceMethodName, extendedParamTypes);
                methodMap.put(interfaceMethod, serviceMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.log.debug("{}", methodMap);
        return methodMap;
    }
}

