/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.lang.reflect.Method;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.classloader.ClassLoaderUtils;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.util.generation.InterfaceTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeContextInstantiationStrategyEnhancerHelper {
    private static final String RUNTIME_CONTEXT = "Lorg/openl/rules/context/IRulesRuntimeContext;";
    private static final String UNDECORATED_CLASS_NAME_SUFFIX = "$RuntimeContextUndecorated";
    private static final String DECORATED_CLASS_NAME_SUFFIX = "$RuntimeContextDecorated";

    private RuntimeContextInstantiationStrategyEnhancerHelper() {
    }

    public static boolean isDecoratedClass(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getParameterTypes().length != 0 && method.getParameterTypes()[0] == IRulesRuntimeContext.class) continue;
            return false;
        }
        return true;
    }

    public static Class<?> undecorateClass(Class<?> clazz, ClassLoader classLoader) throws Exception {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interface classes are supported");
        }
        String className = clazz.getName() + UNDECORATED_CLASS_NAME_SUFFIX;
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Logger log = LoggerFactory.getLogger(RuntimeContextInstantiationStrategyEnhancerHelper.class);
            log.debug("Generating interface without runtime context for '{}' class.", (Object)clazz.getName());
            return RuntimeContextInstantiationStrategyEnhancerHelper.innerUndecorateInterface(className, clazz, classLoader);
        }
    }

    private static Class<?> innerUndecorateInterface(String className, Class<?> original, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        UndecoratingClassWriter classVisitor = new UndecoratingClassWriter((ClassVisitor)classWriter, className);
        InterfaceTransformer transformer = new InterfaceTransformer(original, className, InterfaceTransformer.REMOVE_FIRST_PARAMETER);
        transformer.accept(classVisitor);
        classWriter.visitEnd();
        return ClassLoaderUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
    }

    public static Class<?> decorateClass(Class<?> clazz, ClassLoader classLoader) throws Exception {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interface classes are supported");
        }
        String className = clazz.getName() + DECORATED_CLASS_NAME_SUFFIX;
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Logger log = LoggerFactory.getLogger(RuntimeContextInstantiationStrategyEnhancerHelper.class);
            log.debug("Generating interface with runtime context for '{}' class.", (Object)clazz.getName());
            return RuntimeContextInstantiationStrategyEnhancerHelper.innerDecorateInterface(className, clazz, classLoader);
        }
    }

    private static Class<?> innerDecorateInterface(String className, Class<?> original, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        DecoratingClassWriter classVisitor = new DecoratingClassWriter((ClassVisitor)classWriter, className);
        InterfaceTransformer transformer = new InterfaceTransformer(original, className, InterfaceTransformer.ADD_FIRST_PARAMETER);
        transformer.accept(classVisitor);
        classWriter.visitEnd();
        return ClassLoaderUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
    }

    static class UndecoratingClassWriter
    extends ClassVisitor {
        private final String className;

        public UndecoratingClassWriter(ClassVisitor delegatedClassVisitor, String className) {
            super(327680, delegatedClassVisitor);
            this.className = className;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.className.replace('.', '/'), signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return super.visitMethod(access, name, this.removeRuntimeContextFromDescriptor(descriptor), signature, exceptions);
        }

        private String removeRuntimeContextFromDescriptor(String descriptor) {
            if (descriptor.startsWith("(Lorg/openl/rules/context/IRulesRuntimeContext;")) {
                return "(" + descriptor.substring(RuntimeContextInstantiationStrategyEnhancerHelper.RUNTIME_CONTEXT.length() + 1);
            }
            throw new IllegalArgumentException("IRulesRuntimeContext is expected in signature.");
        }
    }

    static class DecoratingClassWriter
    extends ClassVisitor {
        private final String className;

        public DecoratingClassWriter(ClassVisitor delegatedClassVisitor, String className) {
            super(327680, delegatedClassVisitor);
            this.className = className;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.className.replace('.', '/'), signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return super.visitMethod(access, name, this.addRuntimeContextToDescription(descriptor), signature, exceptions);
        }

        private String addRuntimeContextToDescription(String descriptor) {
            return "(Lorg/openl/rules/context/IRulesRuntimeContext;" + descriptor.substring(1);
        }
    }
}

