/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.IRulesRuntimeContextConsumer;
import org.openl.runtime.AbstractOpenLMethodHandler;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RuntimeContextInstantiationStrategyEnhancerInvocationHandler
extends AbstractOpenLMethodHandler<Method, Method> {
    private final Logger log = LoggerFactory.getLogger(RuntimeContextInstantiationStrategyEnhancerInvocationHandler.class);
    private final Map<Method, Method> methodsMap;
    private final Object serviceClassInstance;

    public Method getTargetMember(Method key) {
        return this.methodsMap.get(key);
    }

    public RuntimeContextInstantiationStrategyEnhancerInvocationHandler(Map<Method, Method> methodsMap, Object serviceClassInstance) {
        this.methodsMap = methodsMap;
        this.serviceClassInstance = serviceClassInstance;
    }

    public Object getTarget() {
        return this.serviceClassInstance;
    }

    public Object invoke(Method method, Object[] args) throws Exception {
        Method member = this.methodsMap.get(method);
        if (member == null) {
            this.log.debug("Invoking not service class method: {} -> {}", (Object)method, (Object)method);
            return method.invoke(this.serviceClassInstance, args);
        }
        this.log.debug("Invoking service class method: {} -> {}", (Object)method, (Object)member);
        IRulesRuntimeContext context = (IRulesRuntimeContext)args[0];
        Object[] methodArgs = ArrayUtils.remove((Object[])args, (int)0);
        this.applyRulesRuntimeContext(this.serviceClassInstance, context);
        return member.invoke(this.serviceClassInstance, methodArgs);
    }

    private void applyRulesRuntimeContext(Object serviceInstance, IRulesRuntimeContext context) {
        Class<?> serviceClass = serviceInstance.getClass();
        if (IEngineWrapper.class.isAssignableFrom(serviceClass)) {
            this.log.debug("Applying runtime context: {} through IEngineWrapper instance", (Object)context);
            IEngineWrapper wrapper = (IEngineWrapper)serviceInstance;
            wrapper.getRuntimeEnv().setContext((IRuntimeContext)context);
        } else if (IRulesRuntimeContextConsumer.class.isAssignableFrom(serviceClass)) {
            this.log.debug("Applying runtime context: {} through IRulesRuntimeContextConsumer instance", (Object)context);
            IRulesRuntimeContextConsumer wrapper = (IRulesRuntimeContextConsumer)serviceInstance;
            wrapper.setRuntimeContext(context);
        } else {
            this.log.error("Failed to define rules runtime context for service instance. Service class must be instance one of: IEngineWrapper.class, IRulesRuntimeContextConsumer.class");
        }
    }
}

