/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.instantiation.CommonRulesInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;

public abstract class SingleModuleInstantiationStrategy
extends CommonRulesInstantiationStrategy {
    private final Module module;

    public SingleModuleInstantiationStrategy(Module module, IDependencyManager dependencyManager, boolean executionMode) {
        this(module, dependencyManager, null, executionMode);
    }

    public SingleModuleInstantiationStrategy(Module module, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode) {
        super(executionMode, dependencyManager, classLoader);
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.initClassLoader();
        }
        return this.classLoader;
    }

    @Override
    protected ClassLoader initClassLoader() {
        ProjectDescriptor project = this.getModule().getProject();
        return new OpenLClassLoader(project.getClassPathUrls(), Thread.currentThread().getContextClassLoader());
    }

    @Override
    public Collection<Module> getModules() {
        return Collections.singleton(this.getModule());
    }

    protected Map<String, Object> prepareExternalParameters() {
        HashMap<String, Object> externalProperties = new HashMap<String, Object>();
        if (this.getModule().getProperties() != null) {
            externalProperties.putAll(this.getModule().getProperties());
        }
        if (this.getExternalParameters() != null) {
            externalProperties.putAll(this.getExternalParameters());
        }
        return externalProperties;
    }
}

