/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.model;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.openl.rules.project.model.MethodFilter;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.WebstudioConfiguration;
import org.openl.rules.project.xml.XmlProjectDescriptorSerializer;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="module")
public class Module {
    @XmlJavaTypeAdapter(value=XmlProjectDescriptorSerializer.CollapsedStringAdapter2.class)
    private String name;
    @XmlElement(name="rules-root")
    private PathEntry rulesRootPath;
    @XmlTransient
    private ProjectDescriptor project;
    @XmlTransient
    private Map<String, Object> properties;
    @XmlElement(name="webstudioConfiguration")
    private WebstudioConfiguration webstudioConfiguration = new WebstudioConfiguration();
    @XmlTransient
    private String wildcardName;
    @XmlTransient
    private String wildcardRulesRootPath;
    @XmlElement(name="method-filter")
    private MethodFilter methodFilter;

    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }

    public void setMethodFilter(MethodFilter methodFilter) {
        this.methodFilter = methodFilter;
    }

    public String getWildcardRulesRootPath() {
        return this.wildcardRulesRootPath;
    }

    public void setWildcardRulesRootPath(String wildcardRulesRootPath) {
        this.wildcardRulesRootPath = wildcardRulesRootPath;
    }

    public WebstudioConfiguration getWebstudioConfiguration() {
        return this.webstudioConfiguration;
    }

    public void setWebstudioConfiguration(WebstudioConfiguration webstudioConfiguration) {
        this.webstudioConfiguration = webstudioConfiguration;
    }

    public String getWildcardName() {
        return this.wildcardName;
    }

    public void setWildcardName(String wildcardName) {
        this.wildcardName = wildcardName;
    }

    public ProjectDescriptor getProject() {
        return this.project;
    }

    public void setProject(ProjectDescriptor project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PathEntry getRulesRootPath() {
        return this.rulesRootPath;
    }

    public Path getRulesPath() {
        return this.project.getProjectFolder().resolve(this.rulesRootPath.getPath()).toAbsolutePath();
    }

    public void setRulesRootPath(PathEntry rulesRootPath) {
        this.rulesRootPath = rulesRootPath;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getRelativeUri() {
        return Optional.ofNullable(this.project.getProjectFolder().getParent()).orElse(this.project.getProjectFolder()).toUri().relativize(this.getRulesPath().toUri()).toString();
    }

    public boolean containsTable(String tableUri) {
        if (tableUri == null || this.getRulesRootPath() == null) {
            return false;
        }
        return tableUri.startsWith(this.getRelativeUri());
    }

    public String toString() {
        return this.name;
    }
}

