/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.project.resolving.InvalidFileNamePatternException;
import org.openl.rules.project.resolving.NoMatchFileNameException;
import org.openl.rules.project.resolving.PropertiesFileNameProcessor;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.util.BooleanUtils;

public class DefaultPropertiesFileNameProcessor
implements PropertiesFileNameProcessor {
    private static final String ARRAY_SEPARATOR = ",";
    private static final String DEFAULT_PATTERN = "[^/]+?";
    private static final Pattern PATTERN = Pattern.compile("(%[^%]+%)");
    private static final String STATE_PROPERTY_NAME = "state";
    private static final String CW_STATE_VALUE = "CW";
    private static final String ALL_KEYWORD = "Any";
    private final Set<String> propertyNames = new LinkedHashSet<String>(0);
    private final Map<String, SimpleDateFormat> dateFormats = new HashMap<String, SimpleDateFormat>();
    private final Pattern fileNameRegexpPattern;
    private final String pattern;

    public DefaultPropertiesFileNameProcessor(String pattern) throws InvalidFileNamePatternException {
        this.pattern = pattern;
        try {
            String regex = this.buildRegexpPattern(pattern);
            this.fileNameRegexpPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidFileNamePatternException("Invalid file name pattern at: " + pattern + "\n" + e.getMessage());
        }
        for (Map.Entry<String, SimpleDateFormat> entry : this.dateFormats.entrySet()) {
            SimpleDateFormat format = entry.getValue();
            format.setLenient(false);
            try {
                Date date;
                Date parsedDate;
                String dateForCheck = "2014-06-20";
                SimpleDateFormat correctFormat = DefaultPropertiesFileNameProcessor.createDateFormat("yyyy-MM-dd");
                if (correctFormat.format(parsedDate = format.parse(format.format(date = correctFormat.parse(dateForCheck)))).equals(dateForCheck)) continue;
                throw new InvalidFileNamePatternException(String.format("Invalid date format for property '%s'.", entry.getKey()));
            }
            catch (ParseException e) {
                throw new InvalidFileNamePatternException(String.format("Invalid date format for property '%s'.", entry.getKey()));
            }
        }
    }

    @Override
    public ITableProperties process(String modulePath) throws NoMatchFileNameException {
        Matcher fileNameMatcher = this.fileNameRegexpPattern.matcher(modulePath);
        if (!fileNameMatcher.matches()) {
            throw new NoMatchFileNameException(String.format("File '%s' does not match file name pattern '%s'.", modulePath, this.pattern));
        }
        TableProperties props = new TableProperties();
        for (String propertyName : this.propertyNames) {
            String group = fileNameMatcher.group(propertyName);
            try {
                Object value = this.convert(propertyName, group);
                props.setFieldValue(propertyName, value);
            }
            catch (Exception e) {
                throw new NoMatchFileNameException(String.format("File '%s' does not match file name pattern '%s'.\r\n Invalid property: %s.\r\n Message: %s.", modulePath, this.pattern, propertyName, e.getMessage()));
            }
        }
        return props;
    }

    private String buildRegexpPattern(String fileNamePattern) throws InvalidFileNamePatternException {
        Matcher matcher = PATTERN.matcher(fileNamePattern);
        int start = 0;
        Object fileNameRegexpPattern = fileNamePattern.replace('*', '\uffff').replace('.', '\ufffe').replace('?', '\ufffd').replace('+', '\ufffc').replace('^', '\ufffb').replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]");
        while (start < fileNamePattern.length()) {
            if (matcher.find(start)) {
                String propertyMatch = matcher.group();
                String multyPropertyNames = propertyMatch.substring(1, propertyMatch.length() - 1);
                String format = null;
                if (multyPropertyNames.contains(":")) {
                    int t = multyPropertyNames.indexOf(58);
                    format = multyPropertyNames.substring(t + 1);
                    multyPropertyNames = multyPropertyNames.substring(0, t);
                }
                Object[] propertyGroup = multyPropertyNames.split(ARRAY_SEPARATOR);
                Class returnType = null;
                StringBuilder finalPattern = null;
                for (String string : propertyGroup) {
                    String pattern;
                    if (!TablePropertyDefinitionUtils.isPropertyExist((String)string)) {
                        throw new InvalidFileNamePatternException(String.format("Found unsupported property '%s' in file name pattern.", string));
                    }
                    if (!this.propertyNames.add(string)) {
                        throw new InvalidFileNamePatternException(String.format("Property '%s' is declared in pattern '%s' several times.", string, fileNamePattern));
                    }
                    Class currentReturnType = TablePropertyDefinitionUtils.getTypeByPropertyName((String)string);
                    if (returnType != null && currentReturnType != returnType) {
                        throw new InvalidFileNamePatternException(String.format("Incompatible properties in the group: %s.", Arrays.toString(propertyGroup)));
                    }
                    returnType = currentReturnType;
                    try {
                        pattern = this.getPattern(string, format, returnType);
                    }
                    catch (RuntimeException e) {
                        throw new InvalidFileNamePatternException(String.format("Invalid file name pattern at: %s.", propertyMatch));
                    }
                    if (finalPattern == null) {
                        finalPattern = new StringBuilder(pattern);
                    }
                    finalPattern = new StringBuilder("(?<" + string + ">" + finalPattern + ")");
                }
                fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace(propertyMatch, finalPattern.toString());
                start = matcher.end();
                continue;
            }
            start = fileNamePattern.length();
        }
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replaceAll("(?<=/)\uffff/", "[^/]+/");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replaceAll("(?<=/)\uffff\uffff/", "(?:[^/]+/)*");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replaceAll("\ufffe\uffff$", "\\.[^/]*");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\ufffe\uffff", "[^/]*");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\uffff", "[^/]*");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\ufffe", "\\.");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\ufffd", "[^/]");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\ufffc", "\\+");
        fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("\ufffb", "\\^");
        fileNameRegexpPattern = ((String)(fileNameRegexpPattern = ((String)fileNameRegexpPattern).replace("$", "\\$"))).startsWith("/") ? ((String)fileNameRegexpPattern).replaceFirst("^/", "^") : "^(?:[^/]+/)*" + (String)fileNameRegexpPattern;
        return (String)fileNameRegexpPattern + "(?:\\.[^.]*)??$";
    }

    private String getPattern(String propertyName, String format, Class<?> returnType) {
        String pattern = DEFAULT_PATTERN;
        if (Boolean.class == returnType) {
            pattern = "[a-zA-Z]+";
        } else if (Date.class == returnType) {
            if (format == null) {
                format = "yyyyMMdd";
            }
            this.dateFormats.put(propertyName, DefaultPropertiesFileNameProcessor.createDateFormat(format));
            pattern = this.dateFormatToPattern(format);
        } else if (returnType.isEnum()) {
            pattern = "[a-zA-Z$_][\\w$_]*";
        } else if (returnType.isArray()) {
            Class<?> componentClass = returnType.getComponentType();
            if (componentClass.isArray()) {
                throw new OpenlNotCheckedException("Two dim arrays are not supported.");
            }
            pattern = this.getPattern(propertyName, format, componentClass);
            if (!DEFAULT_PATTERN.equals(pattern)) {
                pattern = String.format("(?:%s)(?:%s(?:%s))*", pattern, ARRAY_SEPARATOR, pattern);
            }
        }
        return pattern;
    }

    private String dateFormatToPattern(String format) {
        String pattern = format.replaceAll("[ydDwWHkmsSuF]", "\\\\d");
        pattern = pattern.replaceAll("MMM+", "\\\\p{Alpha}+");
        pattern = pattern.replaceAll("MM", "\\\\d{2}");
        pattern = pattern.replaceAll("M", "\\\\d{1,2}");
        return pattern;
    }

    private Object convert(String propertyName, String value) {
        if (STATE_PROPERTY_NAME.equals(propertyName) && CW_STATE_VALUE.equals(value)) {
            return UsStatesEnum.values();
        }
        Class returnType = TablePropertyDefinitionUtils.getTypeByPropertyName((String)propertyName);
        return this.getObject(propertyName, value, returnType);
    }

    private Object getObject(String propertyName, String value, Class<?> clazz) {
        Object[] propValue;
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            propValue = BooleanUtils.toBoolean((Object)value);
        } else if (String.class == clazz) {
            propValue = value;
        } else if (Date.class == clazz) {
            try {
                propValue = this.dateFormats.get(propertyName).parse(value);
            }
            catch (ParseException e) {
                throw new OpenlNotCheckedException(String.format("Failed to parse a date '%s'.", value));
            }
        } else if (clazz.isEnum()) {
            propValue = Enum.valueOf(clazz, value);
        } else if (clazz.isArray()) {
            Class<?> componentClass = clazz.getComponentType();
            if (componentClass.isArray()) {
                throw new OpenlNotCheckedException("Two dim arrays are not supported.");
            }
            propValue = ALL_KEYWORD.equals(value) && componentClass.isEnum() ? componentClass.getEnumConstants() : this.toArray(propertyName, value, componentClass);
        } else {
            throw new OpenlNotCheckedException(String.format("Unsupported data type '%s'.", clazz.getTypeName()));
        }
        return propValue;
    }

    private Object[] toArray(String propertyName, String sourceValue, Class<?> componentClass) {
        String[] values = sourceValue.split(ARRAY_SEPARATOR);
        ArrayList<Object> arrObject = new ArrayList<Object>(values.length);
        for (String str : values) {
            Object arrayValue = this.getObject(propertyName, str, componentClass);
            arrObject.add(arrayValue);
        }
        return arrObject.toArray((Object[])Array.newInstance(componentClass, 0));
    }

    private static SimpleDateFormat createDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

