/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openl.rules.project.ProjectDescriptorManager;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.validation.ValidationException;
import org.openl.rules.project.resolving.NoMatchFileNameException;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.project.resolving.PropertiesFileNameProcessor;
import org.openl.rules.project.resolving.PropertiesFileNameProcessorBuilder;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.rules.table.properties.ITableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDescriptorBasedResolvingStrategy
implements ResolvingStrategy {
    public static final String PROJECT_DESCRIPTOR_FILE_NAME = "rules.xml";
    private static final Logger LOG = LoggerFactory.getLogger(ProjectDescriptorBasedResolvingStrategy.class);

    @Override
    public boolean isRulesProject(Path folder) {
        Path descriptorFile = folder.resolve(PROJECT_DESCRIPTOR_FILE_NAME);
        if (Files.exists(descriptorFile, new LinkOption[0])) {
            LOG.debug("Project in folder '{}' has been resolved as project descriptor based project.", (Object)descriptorFile);
            return true;
        }
        LOG.debug("Project descriptor based strategy is failed to resolve project folder '{}': there is no file '{}' in the folder.", (Object)descriptorFile, (Object)PROJECT_DESCRIPTOR_FILE_NAME);
        return false;
    }

    @Override
    public ProjectDescriptor resolveProject(Path folder) throws ProjectResolvingException {
        Path descriptorFile = folder.resolve(PROJECT_DESCRIPTOR_FILE_NAME);
        LinkedHashSet<String> globalErrorMessages = new LinkedHashSet<String>();
        ProjectDescriptorManager descriptorManager = new ProjectDescriptorManager();
        PropertiesFileNameProcessorBuilder propertiesFileNameProcessorBuilder = new PropertiesFileNameProcessorBuilder();
        try {
            ProjectDescriptor projectDescriptor = descriptorManager.readDescriptor(descriptorFile);
            PropertiesFileNameProcessor processor = null;
            try {
                processor = propertiesFileNameProcessorBuilder.build(projectDescriptor);
            }
            catch (Exception e) {
                globalErrorMessages.add(e.getMessage());
            }
            LinkedHashSet<String> globalWarnMessages = new LinkedHashSet<String>();
            if ("org.openl.rules.project.resolving.CWPropertyFileNameProcessor".equals(projectDescriptor.getPropertiesFileNameProcessor())) {
                globalWarnMessages.add("CWPropertyFileNameProcessor is deprecated. 'CW' keyword support for 'state' property is moved to the default property processor. Remove declaration of this class from 'rules.xml'.");
            }
            for (Module module : projectDescriptor.getModules()) {
                HashSet<CallSite> moduleErrorMessages = new HashSet<CallSite>(globalErrorMessages);
                HashSet<String> moduleWarnMessages = new HashSet<String>(globalWarnMessages);
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (processor != null) {
                    try {
                        String relativePath = module.getRulesRootPath().getPath();
                        ITableProperties tableProperties = processor.process(relativePath);
                        params.put("external-module-properties", tableProperties);
                    }
                    catch (NoMatchFileNameException e) {
                        moduleWarnMessages.add(e.getMessage());
                    }
                    catch (Exception | LinkageError e) {
                        moduleErrorMessages.add((CallSite)((Object)("Failed to load custom file name processor class '" + e.getClass().getTypeName() + "': " + e.getMessage())));
                    }
                }
                params.put("additional-error-messages", moduleErrorMessages);
                params.put("additional-warn-messages", moduleWarnMessages);
                module.setProperties(params);
            }
            ProjectDescriptor projectDescriptor2 = projectDescriptor;
            return projectDescriptor2;
        }
        catch (ValidationException ex) {
            throw new ProjectResolvingException("Project descriptor is wrong. Verify the '\" + PROJECT_DESCRIPTOR_FILE_NAME + \"' file format.", ex);
        }
        catch (FileNotFoundException e) {
            throw new ProjectResolvingException("Project descriptor is not found. File 'rules.xml' is missed.", e);
        }
        catch (Exception e) {
            throw new ProjectResolvingException("Failed to read project descriptor.", e);
        }
        finally {
            propertiesFileNameProcessorBuilder.destroy();
        }
    }
}

