/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.openl.CompiledOpenClass;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolver;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.project.resolving.ProjectResource;
import org.openl.rules.project.resolving.ResolvingStrategy;

public class ProjectResourceLoader {
    private final CompiledOpenClass compiledOpenClass;
    private static final ProjectResource[] EMPTY_ARRAY = new ProjectResource[0];

    public ProjectResourceLoader(CompiledOpenClass compiledOpenClass) {
        this.compiledOpenClass = Objects.requireNonNull(compiledOpenClass, "compiledOpenClass cannot be null");
    }

    public ProjectResource[] loadResource(String name) {
        ClassLoader classloader = this.compiledOpenClass.getClassLoader();
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            URL[] urls = urlClassLoader.getURLs();
            ArrayList<ProjectResource> projectResources = new ArrayList<ProjectResource>();
            for (URL url : urls) {
                String filePath;
                try {
                    filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException ignored) {
                    filePath = url.getFile();
                }
                File projectFolder = new File(filePath);
                ResolvingStrategy resolvingStrategy = ProjectResolver.getInstance().isRulesProject(projectFolder);
                if (resolvingStrategy == null) continue;
                try {
                    ProjectDescriptor projectDescriptor = resolvingStrategy.resolveProject(projectFolder.toPath());
                    try (URLClassLoader urlClassLoader1 = new URLClassLoader(new URL[]{url});){
                        URL resourceURL = urlClassLoader1.getResource(name);
                        if (resourceURL == null) continue;
                        projectResources.add(new ProjectResource(projectDescriptor, resourceURL));
                    }
                }
                catch (IOException | ProjectResolvingException object) {
                    // empty catch block
                }
            }
            return projectResources.toArray(EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }
}

