/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.util.FileTypeHelper;
import org.openl.util.FileUtils;
import org.openl.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleXlsResolvingStrategy
implements ResolvingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleXlsResolvingStrategy.class);

    @Override
    public boolean isRulesProject(Path folder) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return false;
        }
        try {
            boolean isExcelFile;
            try (Stream<Path> stream = Files.walk(folder, 1, new FileVisitOption[0]);){
                isExcelFile = stream.anyMatch(this::isExcelFile);
            }
            if (isExcelFile) {
                LOG.debug("Project in {} folder has been resolved as simple xls project.", (Object)folder);
            } else {
                LOG.debug("Simple xls strategy has failed to resolve project folder: there is no excel files in the folder '{}'.", (Object)folder);
            }
            return isExcelFile;
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProjectDescriptor resolveProject(Path folder) throws ProjectResolvingException {
        final TreeMap modules = new TreeMap();
        try {
            final ProjectDescriptor project = this.createDescriptor(folder);
            Files.walkFileTree(folder, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                    String fileName = f.getFileName().toString();
                    if (!Files.isHidden(f) && attrs.isRegularFile() && FileTypeHelper.isExcelFile((String)fileName)) {
                        String name = FileUtils.removeExtension((String)fileName);
                        if (!modules.containsKey(name)) {
                            String relativePath = project.getProjectFolder().relativize(f.toRealPath(new LinkOption[0]).toAbsolutePath()).toString();
                            PathEntry rootPath = new PathEntry(relativePath);
                            Module module = SimpleXlsResolvingStrategy.this.createModule(project, rootPath, name);
                            modules.put(name, module);
                        } else {
                            LOG.error("A module with the same name already exists: {}", (Object)name);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            project.setModules(new ArrayList<Module>(modules.values()));
            return project;
        }
        catch (IOException e) {
            throw new ProjectResolvingException(e);
        }
    }

    private Module createModule(ProjectDescriptor project, PathEntry rootPath, String name) {
        Module module = new Module();
        module.setProject(project);
        module.setRulesRootPath(rootPath);
        module.setName(name);
        return module;
    }

    private ProjectDescriptor createDescriptor(Path folder) throws IOException {
        ProjectDescriptor project = new ProjectDescriptor();
        project.setProjectFolder(folder.toRealPath(new LinkOption[0]));
        Path fileName = folder.getFileName();
        if (folder.getFileName() == null) {
            fileName = ZipUtils.toPath((URI)folder.toUri()).getFileName();
        }
        project.setName(fileName.toString());
        return project;
    }

    private boolean isExcelFile(Path path) {
        try {
            if (!Files.isHidden(path)) {
                BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                return attrs.isRegularFile() && FileTypeHelper.isExcelFile((String)path.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

