/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import org.openl.rules.project.IProjectDescriptorSerializer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.WebstudioConfiguration;
import org.openl.rules.project.xml.JAXBSerializer;
import org.openl.util.CollectionUtils;

public class XmlProjectDescriptorSerializer
implements IProjectDescriptorSerializer {
    public static final String PROJECT_DESCRIPTOR_TAG = "project";
    public static final String WEBSTUDIO_CONFIGURATION = "webstudioConfiguration";
    public static final String METHOD_FILTER_TAG = "method-filter";
    public static final String DEPENDENCY_TAG = "dependency";
    public static final String PROPERTIES_FILE_NAME_PATTERN = "properties-file-name-pattern";
    public static final String PROPERTIES_FILE_NAME_PROCESSOR = "properties-file-name-processor";
    public static final String STRING_VALUE = "value";
    private final JAXBSerializer jaxbSerializer = new JAXBSerializer(ProjectDescriptor.class);

    @Override
    public String serialize(ProjectDescriptor source) throws IOException, JAXBException {
        this.populateWithNulls(source);
        try {
            String string;
            try (StringWriter stringWriter = new StringWriter();){
                this.jaxbSerializer.marshal((Object)source, stringWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        finally {
            this.populateNullsWithDefaultValues(source);
        }
    }

    @Override
    public ProjectDescriptor deserialize(InputStream source) throws JAXBException {
        ProjectDescriptor descriptor = (ProjectDescriptor)this.jaxbSerializer.unmarshal(source);
        this.populateNullsWithDefaultValues(descriptor);
        return descriptor;
    }

    private void populateNullsWithDefaultValues(ProjectDescriptor descriptor) {
        if (descriptor.getClasspath() == null) {
            descriptor.setClasspath(new ArrayList<PathEntry>());
        }
        if (descriptor.getModules() == null) {
            descriptor.setModules(new ArrayList<Module>());
        }
        for (Module module : descriptor.getModules()) {
            if (module.getWebstudioConfiguration() != null) continue;
            module.setWebstudioConfiguration(new WebstudioConfiguration());
        }
    }

    private void populateWithNulls(ProjectDescriptor descriptor) {
        if (CollectionUtils.isEmpty(descriptor.getClasspath())) {
            descriptor.setClasspath(null);
        }
        if (CollectionUtils.isEmpty(descriptor.getModules())) {
            descriptor.setModules(null);
        }
        for (Module module : descriptor.getModules()) {
            if (module.getWebstudioConfiguration() == null || !Boolean.FALSE.equals(module.getWebstudioConfiguration().isCompileThisModuleOnly())) continue;
            module.setWebstudioConfiguration(null);
        }
    }

    public static class CollapsedStringAdapter2
    extends CollapsedStringAdapter {
        public String marshal(String s) {
            return super.unmarshal(s);
        }
    }
}

