/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.binding.MethodUtil;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.calc.AnySpreadsheetResultOpenClass;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.ruleservice.core.InstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationHelper;
import org.openl.rules.ruleservice.core.annotations.BeanToSpreadsheetResultConvert;
import org.openl.rules.ruleservice.core.annotations.ExternalParam;
import org.openl.rules.ruleservice.core.annotations.NoTypeConversion;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.interceptors.RulesType;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAfterAdvice;
import org.openl.rules.ruleservice.core.interceptors.annotations.NotConvertor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAroundInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.TypeResolver;
import org.openl.rules.ruleservice.core.interceptors.annotations.UseOpenMethodReturnType;
import org.openl.rules.ruleservice.core.interceptors.converters.SPRToPlainConverterAdvice;
import org.openl.rules.ruleservice.core.interceptors.converters.VariationResultSPRToPlainConverterAdvice;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.variation.VariationsResult;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.generation.InterfaceTransformer;

public final class RuleServiceInstantiationFactoryHelper {
    private static final String UNDECORATED_CLASS_NAME_SUFFIX = "$Original";

    private RuleServiceInstantiationFactoryHelper() {
    }

    public static Class<?> buildInterfaceForInstantiationStrategy(Class<?> serviceClass, ClassLoader classLoader, Object serviceTarget, boolean provideRuntimeContext, boolean provideVariations) {
        return RuleServiceInstantiationFactoryHelper.processInterface(null, serviceClass, false, classLoader, serviceTarget, provideRuntimeContext, provideVariations);
    }

    public static Class<?> buildInterfaceForService(IOpenClass openClass, Class<?> serviceClass, ClassLoader classLoader, Object serviceTarget, boolean provideRuntimeContext, boolean provideVariations) {
        return RuleServiceInstantiationFactoryHelper.processInterface(openClass, serviceClass, true, classLoader, serviceTarget, provideRuntimeContext, provideVariations);
    }

    private static Class<?> processInterface(IOpenClass openClass, Class<?> serviceClass, boolean toServiceClass, ClassLoader classLoader, Object serviceTarget, boolean provideRuntimeContext, boolean provideVariations) {
        Objects.requireNonNull(serviceClass, "serviceClass cannot be null");
        HashMap<Method, MethodSignatureChanges> methodsWithSignatureNeedsChange = new HashMap<Method, MethodSignatureChanges>();
        HashSet<Method> methodsToRemove = new HashSet<Method>();
        for (Method method : serviceClass.getMethods()) {
            if (ITableProperties.class.isAssignableFrom(method.getReturnType()) || !toServiceClass && method.isAnnotationPresent(ServiceExtraMethod.class)) {
                methodsToRemove.add(method);
                continue;
            }
            MethodSignatureChanges changes = RuleServiceInstantiationFactoryHelper.getMethodSignatureChanges(method, openClass, classLoader, toServiceClass, serviceTarget, provideRuntimeContext, provideVariations);
            if (changes == null) continue;
            methodsWithSignatureNeedsChange.put(method, changes);
        }
        if (methodsWithSignatureNeedsChange.isEmpty() && methodsToRemove.isEmpty()) {
            return serviceClass;
        }
        ClassWriter classWriter = new ClassWriter(0);
        RuleServiceInterceptorsSupportClassVisitor classVisitor = new RuleServiceInterceptorsSupportClassVisitor((ClassVisitor)classWriter, methodsWithSignatureNeedsChange, methodsToRemove);
        String className = serviceClass.getName() + UNDECORATED_CLASS_NAME_SUFFIX;
        InterfaceTransformer transformer = toServiceClass ? new InterfaceTransformer(serviceClass, className) : new InterfaceTransformer(serviceClass, className, InterfaceTransformer.IGNORE_PARAMETER_ANNOTATIONS);
        transformer.accept((ClassVisitor)classVisitor);
        classWriter.visitEnd();
        try {
            return ClassUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new OpenlNotCheckedException((Throwable)e);
        }
    }

    private static Class<? extends ServiceMethodAfterAdvice<?>> getLastServiceMethodAfterAdvice(ServiceCallAfterInterceptor serviceCallAfterInterceptor) {
        Class[] interceptors = serviceCallAfterInterceptor.value();
        for (int i = interceptors.length - 1; i >= 0; --i) {
            Class serviceMethodAfterAdvice = interceptors[i];
            if (serviceMethodAfterAdvice.isAnnotationPresent(NotConvertor.class)) continue;
            return serviceMethodAfterAdvice;
        }
        return null;
    }

    private static Class<?> resolveNewMethodReturnType(IOpenClass openClass, Method method, IOpenMember openMember, ClassLoader classLoader, boolean toServiceClass, boolean provideVariations) {
        Class<? extends ServiceMethodAfterAdvice<?>> lastServiceMethodAfterAdvice;
        if (toServiceClass && method.isAnnotationPresent(RulesType.class)) {
            RulesType rulesType = method.getAnnotation(RulesType.class);
            Class<?> originType = method.getReturnType();
            return RuleServiceInstantiationFactoryHelper.findOrLoadType(openClass, classLoader, rulesType, originType);
        }
        ServiceCallAfterInterceptor serviceCallAfterInterceptor = method.getAnnotation(ServiceCallAfterInterceptor.class);
        if (!(serviceCallAfterInterceptor == null || provideVariations && method.getReturnType().equals(VariationsResult.class) || (lastServiceMethodAfterAdvice = RuleServiceInstantiationFactoryHelper.getLastServiceMethodAfterAdvice(serviceCallAfterInterceptor)) == null)) {
            return RuleServiceInstantiationFactoryHelper.extractReturnTypeForMethod(openMember, toServiceClass, lastServiceMethodAfterAdvice);
        }
        ServiceCallAroundInterceptor serviceCallAroundInterceptor = method.getAnnotation(ServiceCallAroundInterceptor.class);
        if (!(serviceCallAroundInterceptor == null || provideVariations && method.getReturnType().equals(VariationsResult.class))) {
            Class serviceMethodAroundAdvice = serviceCallAroundInterceptor.value();
            return RuleServiceInstantiationFactoryHelper.extractReturnTypeForMethod(openMember, toServiceClass, serviceMethodAroundAdvice);
        }
        return null;
    }

    private static Class<?> findOrLoadType(IOpenClass openClass, ClassLoader classLoader, RulesType rulesType, Class<?> originType) {
        try {
            Class<?> loadedType = RuleServiceInstantiationFactoryHelper.findOrLoadType(rulesType, openClass, classLoader);
            Class<?> t = originType;
            while (t.isArray()) {
                t = t.getComponentType();
                loadedType = Array.newInstance(loadedType, 0).getClass();
            }
            return loadedType;
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(String.format("Failed to load type '%s' that used in @RulesType annotation.", rulesType.value()));
        }
    }

    public static Class<?> findOrLoadType(RulesType rulesType, IOpenClass openClass, ClassLoader classLoader) throws ClassNotFoundException {
        String typeName = rulesType.value();
        try {
            return classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            for (IOpenClass type : openClass.getTypes()) {
                if (!Objects.equals(type.getName(), typeName)) continue;
                return type.getInstanceClass();
            }
            List sprTypes = openClass.getTypes().stream().filter(CustomSpreadsheetResultOpenClass.class::isInstance).map(CustomSpreadsheetResultOpenClass.class::cast).filter(CustomSpreadsheetResultOpenClass::isGenerateBeanClass).collect(Collectors.toList());
            for (CustomSpreadsheetResultOpenClass sprType : sprTypes) {
                if (!Objects.equals(sprType.getBeanClass().getName(), typeName)) continue;
                return sprType.getBeanClass();
            }
            for (CustomSpreadsheetResultOpenClass sprType : sprTypes) {
                if (!Objects.equals(sprType.getBeanClass().getSimpleName(), typeName)) continue;
                return sprType.getBeanClass();
            }
            throw e;
        }
    }

    static Map<Method, Method> getMethodMap(Class<?> serviceClass, Class<?> serviceTargetClass, Object serviceTarget, ClassLoader serviceClassLoader, IOpenClass openClass) {
        HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Method method : serviceClass.getMethods()) {
            Pair<IOpenMember, Class<?>[]> openMemberResolved = RuleServiceInstantiationFactoryHelper.findIOpenMember(serviceTarget, method, serviceClassLoader, openClass);
            IOpenMember openMember = (IOpenMember)openMemberResolved.getLeft();
            Method serviceTargetMethod = null;
            if (openMember != null) {
                serviceTargetMethod = MethodUtil.getMatchingAccessibleMethod(serviceTargetClass, (String)method.getName(), (Class[])((Class[])openMemberResolved.getRight()));
            }
            methodMap.put(method, serviceTargetMethod);
        }
        return methodMap;
    }

    private static Pair<IOpenMember, Class<?>[]> findIOpenMember(Object serviceTarget, Method method, ClassLoader serviceClassLoader, IOpenClass openClass) {
        for (Class<?> clazz : serviceTarget.getClass().getInterfaces()) {
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                int i = 0;
                for (Parameter parameter : method.getParameters()) {
                    if (parameter.isAnnotationPresent(ExternalParam.class)) {
                        parameterTypes[i] = null;
                    } else if (parameter.isAnnotationPresent(BeanToSpreadsheetResultConvert.class)) {
                        Class<?> t = parameterTypes[i];
                        int dim = 0;
                        while (t.isArray()) {
                            t = t.getComponentType();
                            ++dim;
                        }
                        if (t.isAnnotationPresent(SpreadsheetResultBeanClass.class)) {
                            parameterTypes[i] = dim > 0 ? Array.newInstance(SpreadsheetResult.class, dim).getClass() : SpreadsheetResult.class;
                        }
                    } else if (parameter.isAnnotationPresent(RulesType.class)) {
                        parameterTypes[i] = RuleServiceInstantiationFactoryHelper.findOrLoadType(openClass, serviceClassLoader, parameter.getAnnotation(RulesType.class), parameterTypes[i]);
                    }
                    ++i;
                }
                parameterTypes = (Class[])Arrays.stream(parameterTypes).filter(Objects::nonNull).toArray(Class[]::new);
                Method m = clazz.getMethod(method.getName(), parameterTypes);
                return Pair.of((Object)RuleServiceOpenLServiceInstantiationHelper.getOpenMember(m, serviceTarget), parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return Pair.of(null, null);
    }

    private static Class<?> extractReturnTypeForMethod(IOpenMember openMember, boolean toServiceClass, Class<? extends ServiceMethodAdvice> serviceMethodAdvice) {
        if (toServiceClass) {
            UseOpenMethodReturnType useOpenMethodReturnType = serviceMethodAdvice.getAnnotation(UseOpenMethodReturnType.class);
            if (useOpenMethodReturnType != null) {
                return RuleServiceInstantiationFactoryHelper.extractOpenMethodReturnType(openMember, useOpenMethodReturnType.value());
            }
            return null;
        }
        return Object.class;
    }

    private static Class<?> extractOpenMethodReturnType(IOpenMember openMember, TypeResolver typeResolver) {
        IOpenClass returnType = openMember.getType();
        switch (typeResolver) {
            case ORIGINAL: {
                return returnType.getInstanceClass();
            }
            case IF_SPR_TO_PLAIN: {
                IOpenClass type = returnType;
                int dim = 0;
                while (type.isArray()) {
                    type = type.getComponentClass();
                    ++dim;
                }
                if (type instanceof CustomSpreadsheetResultOpenClass && ((CustomSpreadsheetResultOpenClass)type).isGenerateBeanClass()) {
                    Class<?> t = ((CustomSpreadsheetResultOpenClass)type).getBeanClass();
                    return dim > 0 ? Array.newInstance(t, dim).getClass() : t;
                }
                if (type instanceof SpreadsheetResultOpenClass) {
                    Class<Object> t = ((SpreadsheetResultOpenClass)type).getModule() != null ? ((SpreadsheetResultOpenClass)type).toCustomSpreadsheetResultOpenClass().getBeanClass() : type.getInstanceClass();
                    return dim > 0 ? Array.newInstance(t, dim).getClass() : t;
                }
                return returnType.getInstanceClass();
            }
        }
        throw new IllegalStateException();
    }

    private static boolean isTypeChangingAnnotationPresent(Method method) {
        return method.isAnnotationPresent(ServiceCallAfterInterceptor.class) || method.isAnnotationPresent(ServiceCallAroundInterceptor.class);
    }

    private static MethodSignatureChanges getMethodSignatureChanges(Method method, IOpenClass openClass, ClassLoader classLoader, boolean toServiceClass, Object serviceTarget, boolean provideRuntimeContext, boolean provideVariations) {
        MethodSignatureChanges changes;
        IOpenMember openMember = null;
        if (toServiceClass && !method.isAnnotationPresent(ServiceExtraMethod.class)) {
            ArrayList parameterTypes = new ArrayList();
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isAnnotationPresent(ExternalParam.class)) continue;
                RulesType rulesType = parameter.getAnnotation(RulesType.class);
                Class<?> originType = parameter.getType();
                if (rulesType != null) {
                    Class<?> type = RuleServiceInstantiationFactoryHelper.findOrLoadType(openClass, classLoader, rulesType, originType);
                    parameterTypes.add(type);
                    continue;
                }
                parameterTypes.add(originType);
            }
            openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember(method.getName(), parameterTypes.toArray(new Class[0]), serviceTarget);
            if (openMember == null) {
                throw new IllegalStateException("Open member is not found.");
            }
        }
        Pair<Class<?>, Boolean>[] newParamTypes = RuleServiceInstantiationFactoryHelper.resolveNewMethodParamTypes(method, openClass, classLoader, openMember, toServiceClass, provideRuntimeContext);
        Class<?> newReturnType = RuleServiceInstantiationFactoryHelper.resolveNewMethodReturnType(openClass, method, openMember, classLoader, toServiceClass, provideVariations);
        if (newReturnType != null) {
            changes = new MethodSignatureChanges(newParamTypes, newReturnType, false);
        } else if (openMember != null && !RuleServiceInstantiationFactoryHelper.isTypeChangingAnnotationPresent(method)) {
            IOpenClass type = openMember.getType();
            int dim = 0;
            while (type.isArray()) {
                type = type.getComponentClass();
                ++dim;
            }
            if (provideVariations && method.getReturnType().equals(VariationsResult.class)) {
                changes = new MethodSignatureChanges(newParamTypes, VariationsResult.class, true);
            } else if (type instanceof CustomSpreadsheetResultOpenClass || type instanceof SpreadsheetResultOpenClass || type instanceof AnySpreadsheetResultOpenClass) {
                Class<Object> t = type instanceof CustomSpreadsheetResultOpenClass && ((CustomSpreadsheetResultOpenClass)type).isGenerateBeanClass() ? ((CustomSpreadsheetResultOpenClass)type).getBeanClass() : (type instanceof SpreadsheetResultOpenClass && ((SpreadsheetResultOpenClass)type).getModule() != null ? ((SpreadsheetResultOpenClass)type).toCustomSpreadsheetResultOpenClass().getBeanClass() : Map.class);
                if (dim > 0) {
                    t = Array.newInstance(t, new int[dim]).getClass();
                }
                changes = new MethodSignatureChanges(newParamTypes, t, true);
            } else {
                changes = JavaOpenClass.OBJECT.equals((Object)type) && !JavaOpenClass.OBJECT.equals((Object)openMember.getType()) ? new MethodSignatureChanges(newParamTypes, openMember.getType().getInstanceClass(), true) : (newParamTypes != null ? new MethodSignatureChanges(newParamTypes, null, false) : null);
            }
        } else {
            changes = newParamTypes != null ? new MethodSignatureChanges(newParamTypes, null, false) : null;
        }
        return changes;
    }

    private static Pair<Class<?>, Boolean>[] resolveNewMethodParamTypes(Method method, IOpenClass openClass, ClassLoader classLoader, IOpenMember openMember, boolean toServiceClass, boolean provideRuntimeContext) {
        ArrayList<Pair> methodParamTypes = new ArrayList<Pair>();
        boolean f = false;
        int i = 0;
        for (Parameter parameter : method.getParameters()) {
            if (!toServiceClass && parameter.isAnnotationPresent(ExternalParam.class)) {
                f = true;
            } else {
                Class<?> methodParamType = method.getParameterTypes()[i];
                Boolean paramTypeSprToBeanConversation = Boolean.FALSE;
                if (parameter.getType().equals(Object.class) && parameter.isAnnotationPresent(RulesType.class)) {
                    RulesType rulesType = parameter.getAnnotation(RulesType.class);
                    try {
                        Class<?> loadedType = RuleServiceInstantiationFactoryHelper.findOrLoadType(rulesType, openClass, classLoader);
                        Class<?> t = method.getParameterTypes()[i];
                        while (t.isArray()) {
                            t = t.getComponentType();
                            loadedType = Array.newInstance(loadedType, 0).getClass();
                        }
                        methodParamType = loadedType;
                        f = true;
                    }
                    catch (ClassNotFoundException e) {
                        throw new InstantiationException(String.format("Failed to load type '%s' that used in @RulesType annotation.", rulesType.value()));
                    }
                } else {
                    Class<SpreadsheetResult> baseParameterType = parameter.getType();
                    int dim = 0;
                    while (baseParameterType.isArray()) {
                        baseParameterType = baseParameterType.getComponentType();
                        ++dim;
                    }
                    if (toServiceClass && openMember instanceof IOpenMethod && baseParameterType.isAssignableFrom(SpreadsheetResult.class) && !parameter.isAnnotationPresent(NoTypeConversion.class)) {
                        IOpenMethod openMethod = (IOpenMethod)openMember;
                        if (!(provideRuntimeContext && i <= 0 || i - (provideRuntimeContext ? 1 : 0) >= openMethod.getSignature().getNumberOfParameters())) {
                            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass;
                            IOpenClass baseOpenParameterType = openMethod.getSignature().getParameterType(i - (provideRuntimeContext ? 1 : 0));
                            int d = 0;
                            while (baseOpenParameterType.isArray()) {
                                baseOpenParameterType = baseOpenParameterType.getComponentClass();
                                ++d;
                            }
                            if (dim != d) {
                                throw new InstantiationException(String.format("Unexpected array dimension size for '%s' method parameter '%s'. Expected dimension size is '%s', but found '%s'.", MethodUtil.printMethod((String)method.getName(), (Class[])method.getParameterTypes()), i, d, dim));
                            }
                            if ((baseOpenParameterType instanceof CustomSpreadsheetResultOpenClass || baseOpenParameterType instanceof SpreadsheetResultOpenClass) && (customSpreadsheetResultOpenClass = baseOpenParameterType instanceof CustomSpreadsheetResultOpenClass ? (CustomSpreadsheetResultOpenClass)baseOpenParameterType : ((SpreadsheetResultOpenClass)baseOpenParameterType).toCustomSpreadsheetResultOpenClass()).isGenerateBeanClass() && parameter.getType() != customSpreadsheetResultOpenClass.getBeanClass()) {
                                Class<?> t = customSpreadsheetResultOpenClass.getBeanClass();
                                methodParamType = dim > 0 ? Array.newInstance(t, dim).getClass() : t;
                                paramTypeSprToBeanConversation = Boolean.TRUE;
                                f = true;
                            }
                        }
                    } else if (!toServiceClass && !parameter.isAnnotationPresent(NoTypeConversion.class) && baseParameterType.isAnnotationPresent(SpreadsheetResultBeanClass.class)) {
                        methodParamType = dim > 0 ? Array.newInstance(SpreadsheetResult.class, dim).getClass() : SpreadsheetResult.class;
                        paramTypeSprToBeanConversation = Boolean.TRUE;
                        f = true;
                    }
                }
                methodParamTypes.add(Pair.of(methodParamType, (Object)paramTypeSprToBeanConversation));
            }
            ++i;
        }
        return f ? methodParamTypes.toArray(new Pair[0]) : null;
    }

    private static class MethodSignatureChanges {
        boolean generateReturnConverters;
        Pair<Class<?>, Boolean>[] newParamTypes;
        Class<?> returnType;

        public MethodSignatureChanges(Pair<Class<?>, Boolean>[] newParamTypes, Class<?> returnType, boolean generateReturnConverters) {
            this.newParamTypes = newParamTypes;
            this.generateReturnConverters = generateReturnConverters;
            this.returnType = returnType;
        }

        public Pair<Class<?>, Boolean>[] getNewParamTypes() {
            return this.newParamTypes;
        }

        public boolean isGenerateReturnConverters() {
            return this.generateReturnConverters;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }
    }

    private static class RuleServiceInterceptorsSupportClassVisitor
    extends ClassVisitor {
        private final Map<String, List<Pair<Method, MethodSignatureChanges>>> methodsWithSignatureNeedsChange;
        private final Map<String, List<Method>> methodsToRemove;

        private RuleServiceInterceptorsSupportClassVisitor(ClassVisitor visitor, Map<Method, MethodSignatureChanges> methodsWithSignatureNeedsChange, Collection<Method> methodsToRemove) {
            super(327680, visitor);
            List listOfMethods;
            Objects.requireNonNull(methodsWithSignatureNeedsChange, "methodsWithSignatureNeedsChange cannot be null");
            this.methodsWithSignatureNeedsChange = new HashMap<String, List<Pair<Method, MethodSignatureChanges>>>();
            for (Map.Entry<Method, MethodSignatureChanges> entry : methodsWithSignatureNeedsChange.entrySet()) {
                listOfMethods = this.methodsWithSignatureNeedsChange.computeIfAbsent(entry.getKey().getName(), e -> new ArrayList());
                listOfMethods.add(Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
            }
            Objects.requireNonNull(methodsToRemove, "methodsToRemove cannot be null");
            this.methodsToRemove = new HashMap<String, List<Method>>();
            for (Method method : methodsToRemove) {
                listOfMethods = this.methodsToRemove.computeIfAbsent(method.getName(), e -> new ArrayList());
                listOfMethods.add(method);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            List<Pair<Method, MethodSignatureChanges>> listOfMethods;
            List<Method> listOfMethodsToRemove = this.methodsToRemove.get(name);
            if (listOfMethodsToRemove != null) {
                for (Method method : listOfMethodsToRemove) {
                    if (!descriptor.equals(Type.getMethodDescriptor((Method)method))) continue;
                    return null;
                }
            }
            if ((listOfMethods = this.methodsWithSignatureNeedsChange.get(name)) != null) {
                for (Pair<Method, MethodSignatureChanges> entry : listOfMethods) {
                    Method method = (Method)entry.getKey();
                    if (!descriptor.equals(Type.getMethodDescriptor((Method)method))) continue;
                    Pair<Class<?>, Boolean>[] newParamTypes = ((MethodSignatureChanges)entry.getValue()).getNewParamTypes();
                    Class<?> newRetType = ((MethodSignatureChanges)entry.getValue()).getReturnType();
                    MethodVisitor mv = super.visitMethod(access, name, Type.getMethodDescriptor((Type)(newRetType != null ? Type.getType(newRetType) : Type.getReturnType((String)descriptor)), (Type[])(newParamTypes != null ? (Type[])Arrays.stream(newParamTypes).map(Pair::getLeft).map(Type::getType).toArray(Type[]::new) : Type.getArgumentTypes((String)descriptor))), signature, exceptions);
                    if (newRetType != null && ((MethodSignatureChanges)entry.getValue()).isGenerateReturnConverters()) {
                        AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(ServiceCallAfterInterceptor.class), true);
                        AnnotationVisitor av1 = av.visitArray("value");
                        av1.visit("value", (Object)Type.getType(VariationsResult.class.equals(newRetType) ? VariationResultSPRToPlainConverterAdvice.class : SPRToPlainConverterAdvice.class));
                        av1.visitEnd();
                        av.visitEnd();
                    }
                    if (newParamTypes != null) {
                        for (int i = 0; i < newParamTypes.length; ++i) {
                            if (!Boolean.TRUE.equals(newParamTypes[i].getValue())) continue;
                            AnnotationVisitor av = mv.visitParameterAnnotation(i, Type.getDescriptor(BeanToSpreadsheetResultConvert.class), true);
                            av.visitEnd();
                        }
                    }
                    return mv;
                }
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

