/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.binding.impl.cast.OutsideOfValidDomainException;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.exception.OpenLUserRuntimeException;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanPropertyNamingStrategy;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;

public class RuleServiceWrapperException
extends RuleServiceRuntimeException {
    private static final long serialVersionUID = 3618613334261575918L;
    private final Object body;
    private final ExceptionType type;

    private RuleServiceWrapperException(Object details, ExceptionType type, String message, Throwable cause) {
        super(message, cause);
        this.body = details;
        this.type = type;
    }

    public RuleServiceWrapperException(String message, ExceptionType type) {
        super(message);
        this.body = null;
        this.type = type;
    }

    public static RuleServiceWrapperException create(Throwable ex, SpreadsheetResultBeanPropertyNamingStrategy namingStrategy) {
        Object body = null;
        ExceptionType type = ExceptionType.SYSTEM;
        String message = ex.getMessage();
        for (Throwable t : ExceptionUtils.getThrowableList((Throwable)ex)) {
            if (t instanceof OpenLUserRuntimeException) {
                body = ((OpenLUserRuntimeException)t).getBody();
                body = SpreadsheetResult.convertSpreadsheetResult((Object)body, (SpreadsheetResultBeanPropertyNamingStrategy)namingStrategy);
                type = ExceptionType.USER_ERROR;
                message = t.getMessage();
                continue;
            }
            if (t instanceof OutsideOfValidDomainException) {
                type = ExceptionType.VALIDATION;
                message = t.getMessage();
                continue;
            }
            if (t instanceof OpenLRuntimeException) {
                type = ExceptionType.RULES_RUNTIME;
                message = t.getMessage();
                continue;
            }
            if (!(t instanceof OpenLCompilationException)) continue;
            type = ExceptionType.COMPILATION;
            message = t.getMessage();
        }
        return new RuleServiceWrapperException(body, type, message, ex);
    }

    public Object getBody() {
        return this.body;
    }

    public ExceptionType getType() {
        return this.type;
    }
}

