/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.common;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import org.openl.binding.MethodUtil;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.ruleservice.core.annotations.ExternalParam;
import org.openl.rules.ruleservice.core.annotations.Name;
import org.openl.rules.variation.VariationsPack;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.util.ClassUtils;
import org.openl.util.JavaKeywordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtils {
    private MethodUtils() {
    }

    private static void validateAndUpdateParameterNames(String[] parameterNames) {
        HashSet<String> allNames = new HashSet<String>(Arrays.asList(parameterNames));
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < parameterNames.length; ++i) {
            if (allNames.contains(parameterNames[i])) {
                allNames.remove(parameterNames[i]);
                usedNames.add(parameterNames[i]);
                continue;
            }
            int j = 0;
            while (allNames.contains("arg" + j) || usedNames.contains("arg" + j)) {
                ++j;
            }
            parameterNames[i] = "arg" + j;
        }
    }

    public static String[] getParameterNames(IOpenMember openMember, Method method, boolean provideRuntimeContext, boolean provideVariations) {
        int i;
        IOpenField openField;
        String[] parameterNames = new String[method.getParameterCount()];
        if (openMember instanceof IOpenMethod) {
            int i2 = 0;
            int j = 0;
            IOpenMethod openMethod = (IOpenMethod)openMember;
            IMethodSignature methodSignature = openMethod.getSignature();
            for (Parameter parameter : method.getParameters()) {
                if (i2 == 0 && provideRuntimeContext && method.getParameterTypes().length > 0 && IRulesRuntimeContext.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    parameterNames[i2] = "runtimeContext";
                } else if (i2 == method.getParameterCount() - 1 && provideVariations && VariationsPack.class.isAssignableFrom(method.getParameters()[method.getParameters().length - 1].getType())) {
                    parameterNames[i2] = "variationPack";
                } else if (!parameter.isAnnotationPresent(ExternalParam.class)) {
                    parameterNames[i2] = methodSignature.getParameterName(j++);
                }
                ++i2;
            }
        } else if (openMember instanceof IOpenField && ClassUtils.getter((String)(openField = (IOpenField)openMember).getName()).equals(method.getName())) {
            if (provideRuntimeContext && method.getParameterTypes().length > 0 && IRulesRuntimeContext.class.isAssignableFrom(method.getParameterTypes()[0])) {
                parameterNames[0] = "runtimeContext";
            }
            if (provideVariations && VariationsPack.class.isAssignableFrom(method.getParameters()[method.getParameters().length - 1].getType())) {
                parameterNames[1] = "variationPack";
            }
        }
        int j = 0;
        for (i = 0; i < parameterNames.length; ++i) {
            if (parameterNames[i] != null) continue;
            parameterNames[i] = "arg" + j;
            ++j;
        }
        MethodUtils.fixJavaKeyWords(parameterNames);
        i = 0;
        for (Parameter parameter : method.getParameters()) {
            Name name = parameter.getAnnotation(Name.class);
            if (name != null) {
                if (!name.value().isEmpty() && !JavaKeywordUtils.isJavaKeyword((String)name.value())) {
                    parameterNames[i] = name.value();
                } else {
                    Logger log = LoggerFactory.getLogger(MethodUtils.class);
                    if (log.isWarnEnabled()) {
                        log.warn("Invalid parameter name '{}' is used in @Name annotation for the method '{}.{}'.", new Object[]{name.value(), method.getClass().getTypeName(), MethodUtil.printMethod((String)method.getName(), (Class[])method.getParameterTypes())});
                    }
                }
            }
            ++i;
        }
        MethodUtils.validateAndUpdateParameterNames(parameterNames);
        return parameterNames;
    }

    private static void fixJavaKeyWords(String[] parameterNames) {
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!JavaKeywordUtils.isJavaKeyword((String)parameterNames[i])) continue;
            int k = 0;
            boolean f = false;
            while (!f) {
                String s = parameterNames[i] + ++k;
                boolean g = true;
                for (int j = 0; j < parameterNames.length; ++j) {
                    if (j == i || !s.equals(parameterNames[j])) continue;
                    g = false;
                    break;
                }
                if (!g) continue;
                f = true;
            }
            int n = i;
            parameterNames[n] = parameterNames[n] + k;
        }
    }
}

