/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.xml.ElementClass;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.binding.MethodUtil;
import org.openl.gen.FieldDescription;
import org.openl.rules.datatype.gen.ASMUtils;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationHelper;
import org.openl.rules.ruleservice.core.annotations.ApiErrors;
import org.openl.rules.ruleservice.publish.common.MethodUtils;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSErrorResponse;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSUserErrorResponse;
import org.openl.rules.ruleservice.publish.jaxrs.WrapperBeanClassBuilder;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.util.ClassUtils;
import org.openl.util.JAXBUtils;
import org.openl.util.StringUtils;
import org.openl.util.generation.InterfaceTransformer;

public class JAXRSOpenLServiceEnhancerHelper {
    public static final int MAX_PARAMETERS_COUNT_FOR_GET = 3;
    public static final int UNPROCESSABLE_ENTITY = 422;
    private static final String DECORATED_CLASS_NAME_SUFFIX = "$JAXRSAnnotated";
    private static final Set<Class<?>> TEXT_MEDIA_TYPE_SET = new HashSet();

    public static Map<Method, Method> buildMethodMap(Class<?> serviceClass, Class<?> enhancedServiceClass) throws Exception {
        HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Method method : enhancedServiceClass.getMethods()) {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            try {
                Method targetMethod = serviceClass.getMethod(methodName, parameterTypes);
                methodMap.put(method, targetMethod);
            }
            catch (NoSuchMethodException ex) {
                if (parameterTypes.length > 0) {
                    Class<?> methodArgument = parameterTypes[0];
                    parameterTypes = (Class[])methodArgument.getMethod("_types", new Class[0]).invoke(null, new Object[0]);
                }
                Method targetMethod = serviceClass.getMethod(methodName, parameterTypes);
                methodMap.put(method, targetMethod);
            }
        }
        return methodMap;
    }

    public static boolean isParameterInWrapperClass(java.lang.reflect.Parameter parameter) {
        return !parameter.isAnnotationPresent(Context.class);
    }

    public static Class<?> enhanceInterface(Class<?> originalClass, Object targetService, ClassLoader classLoader, boolean provideRuntimeContext, boolean provideVariations) throws Exception {
        Class enhancedClass;
        if (!originalClass.isInterface()) {
            throw new IllegalArgumentException("Only interfaces are supported");
        }
        String enhancedClassName = originalClass.getName() + DECORATED_CLASS_NAME_SUFFIX;
        try {
            enhancedClass = classLoader.loadClass(enhancedClassName);
        }
        catch (ClassNotFoundException e) {
            ClassWriter cw = new ClassWriter(0);
            JAXRSInterfaceAnnotationEnhancerClassVisitor enhancerClassVisitor = new JAXRSInterfaceAnnotationEnhancerClassVisitor((ClassVisitor)cw, originalClass, targetService, classLoader, provideRuntimeContext, provideVariations);
            InterfaceTransformer transformer = new InterfaceTransformer(originalClass, enhancedClassName, InterfaceTransformer.IGNORE_PARAMETER_ANNOTATIONS);
            transformer.accept((ClassVisitor)enhancerClassVisitor);
            cw.visitEnd();
            enhancedClass = ClassUtils.defineClass((String)enhancedClassName, (byte[])cw.toByteArray(), (ClassLoader)classLoader);
        }
        return enhancedClass;
    }

    static {
        TEXT_MEDIA_TYPE_SET.add(Number.class);
        TEXT_MEDIA_TYPE_SET.add(Enum.class);
        TEXT_MEDIA_TYPE_SET.add(String.class);
        TEXT_MEDIA_TYPE_SET.add(Date.class);
        TEXT_MEDIA_TYPE_SET.add(Instant.class);
        TEXT_MEDIA_TYPE_SET.add(ZonedDateTime.class);
        TEXT_MEDIA_TYPE_SET.add(LocalDateTime.class);
        TEXT_MEDIA_TYPE_SET.add(LocalDate.class);
        TEXT_MEDIA_TYPE_SET.add(LocalTime.class);
        TEXT_MEDIA_TYPE_SET.add(Character.class);
        TEXT_MEDIA_TYPE_SET.add(Boolean.class);
    }

    private static class JAXRSInterfaceAnnotationEnhancerClassVisitor
    extends ClassVisitor {
        private static final String DEFAULT_VERSION = "1.0.0";
        private static final String UNPROCESSABLE_ENTITY_MESSAGE = "Custom user errors in rules or validation errors in input parameters";
        private static final String UNPROCESSABLE_ENTITY_EXAMPLE = "{\"message\": \"Some message\", \"type\": \"USER_ERROR\"}";
        private static final String USER_ERROR_EXAMPLE = "{\"message\": \"Some message\", \"code\": \"code.example\", \"type\": \"USER_ERROR\"}";
        private static final String BAD_REQUEST_MESSAGE = "Invalid request format e.g. missing required field, unparseable JSON value, etc.";
        private static final String BAD_REQUEST_EXAMPLE = "{\"message\": \"Cannot parse 'bar' to JSON\", \"type\": \"BAD_REQUEST\"}";
        private static final String INTERNAL_SERVER_ERROR_MESSAGE = "Internal server errors e.g. compilation or parsing errors, runtime exceptions, etc.";
        private static final String INTERNAL_SERVER_ERROR_EXAMPLE = "{\"message\": \"Failed to load lazy method.\", \"type\": \"COMPILATION\"}";
        private static final Class<?>[] DEFAULT_API_ERROR_TYPES = new Class[]{JAXRSErrorResponse.class};
        private static final String REQUEST_PARAMETER_SUFFIX = "Request";
        private final Class<?> originalClass;
        private final ClassLoader classLoader;
        private Set<String> usedPaths = null;
        private final Set<String> nicknames = new HashSet<String>();
        private final boolean provideRuntimeContext;
        private final boolean provideVariations;
        private Set<String> usedOpenApiComponentNamesWithRequestParameterSuffix = null;
        private final Object targetService;
        private final Map<String, List<Method>> originalClassMethodsByName;

        JAXRSInterfaceAnnotationEnhancerClassVisitor(ClassVisitor arg0, Class<?> originalClass, Object targetService, ClassLoader classLoader, boolean provideRuntimeContext, boolean provideVariations) {
            super(327680, arg0);
            this.originalClass = Objects.requireNonNull(originalClass, "originalClass cannot be null");
            this.classLoader = classLoader;
            this.provideRuntimeContext = provideRuntimeContext;
            this.provideVariations = provideVariations;
            this.targetService = targetService;
            this.originalClassMethodsByName = ASMUtils.buildMap(originalClass);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            if (!this.originalClass.isAnnotationPresent(Path.class)) {
                AnnotationVisitor annotationVisitor = this.visitAnnotation(Type.getDescriptor(Path.class), true);
                annotationVisitor.visit("value", (Object)"/");
                annotationVisitor.visitEnd();
            }
            if (!this.originalClass.isAnnotationPresent(Consumes.class)) {
                this.addConsumesAnnotation(this);
            }
            if (!this.originalClass.isAnnotationPresent(Produces.class)) {
                this.addProducesAnnotation(this);
            }
            if (!this.originalClass.isAnnotationPresent(ApiResponses.class) && !this.originalClass.isAnnotationPresent(ApiResponse.class)) {
                this.addOpenApiResponsesAnnotation(this);
            }
        }

        private String getOpenApiComponentName(Class<?> clazz) {
            Schema schema = clazz.getAnnotation(Schema.class);
            return schema == null ? clazz.getSimpleName() : schema.name();
        }

        private Set<String> getUsedOpenApiComponentNamesWithRequestParameterSuffix() {
            if (this.usedOpenApiComponentNamesWithRequestParameterSuffix == null) {
                this.usedOpenApiComponentNamesWithRequestParameterSuffix = new HashSet<String>();
                for (Method method : this.originalClass.getDeclaredMethods()) {
                    this.processClassForOpenApiComponentNamesConflictResolving(method.getReturnType());
                    for (Class<?> paramType : method.getParameterTypes()) {
                        this.processClassForOpenApiComponentNamesConflictResolving(paramType);
                    }
                }
            }
            return this.usedOpenApiComponentNamesWithRequestParameterSuffix;
        }

        private void processClassForOpenApiComponentNamesConflictResolving(Class<?> type) {
            while (type.isArray()) {
                type = type.getComponentType();
            }
            String componentName = this.getOpenApiComponentName(type);
            if (this.isConflictPossible(componentName)) {
                this.usedOpenApiComponentNamesWithRequestParameterSuffix.add(componentName);
            }
        }

        private boolean isConflictPossible(String name) {
            while (Character.isDigit(name.charAt(name.length() - 1))) {
                name = name.substring(0, name.length() - 1);
            }
            return name.endsWith(REQUEST_PARAMETER_SUFFIX);
        }

        private String changedParameterTypesDescription(String descriptor, Method originalMethod, int suffix) throws Exception {
            Class<?> parameterWrapperClass = this.generateWrapperClass(originalMethod, suffix);
            ArrayList<Type> types = new ArrayList<Type>();
            types.add(Type.getType(parameterWrapperClass));
            for (java.lang.reflect.Parameter parameter : originalMethod.getParameters()) {
                if (JAXRSOpenLServiceEnhancerHelper.isParameterInWrapperClass(parameter)) continue;
                types.add(Type.getType(parameter.getType()));
            }
            return Type.getMethodDescriptor((Type)Type.getReturnType((String)descriptor), (Type[])types.toArray(new Type[0]));
        }

        private Class<?> generateWrapperClass(Method originalMethod, int suffix) throws Exception {
            String[] parameterNames = this.resolveParameterNames(originalMethod);
            String requestParameterName = StringUtils.capitalize((String)originalMethod.getName()) + REQUEST_PARAMETER_SUFFIX;
            if (suffix > 0) {
                requestParameterName = requestParameterName + suffix;
            }
            String nonConflictedRequestParameterName = requestParameterName;
            StringBuilder s = new StringBuilder("0");
            while (this.getUsedOpenApiComponentNamesWithRequestParameterSuffix().contains(nonConflictedRequestParameterName)) {
                nonConflictedRequestParameterName = StringUtils.capitalize((String)originalMethod.getName()) + REQUEST_PARAMETER_SUFFIX + s + (Serializable)(suffix > 0 ? Integer.valueOf(suffix) : "");
                s.insert(0, "0");
            }
            this.usedOpenApiComponentNamesWithRequestParameterSuffix.add(nonConflictedRequestParameterName);
            String beanName = "org.openl.jaxrs." + nonConflictedRequestParameterName;
            int i = 0;
            WrapperBeanClassBuilder beanClassBuilder = new WrapperBeanClassBuilder(beanName, originalMethod.getName());
            LinkedHashMap<String, FieldDescription> originalMethodTypeFields = new LinkedHashMap<String, FieldDescription>();
            for (java.lang.reflect.Parameter parameter : originalMethod.getParameters()) {
                if (JAXRSOpenLServiceEnhancerHelper.isParameterInWrapperClass(parameter)) {
                    beanClassBuilder.addField(parameterNames[i], parameter.getType().getName());
                }
                originalMethodTypeFields.put(parameterNames[i], new FieldDescription(parameter.getType().getName()));
                ++i;
            }
            beanClassBuilder.setOriginalMethodTypeFields(originalMethodTypeFields);
            byte[] byteCode = beanClassBuilder.byteCode();
            return ClassUtils.defineClass((String)beanName, (byte[])byteCode, (ClassLoader)this.classLoader);
        }

        Set<String> getUsedPaths() {
            if (this.usedPaths == null) {
                this.usedPaths = new HashSet<String>();
                for (Method m : this.originalClass.getMethods()) {
                    Path pathAnnotation = m.getAnnotation(Path.class);
                    if (pathAnnotation == null) continue;
                    String value = pathAnnotation.value();
                    this.usedPaths.add(this.normalizePath(value));
                }
            }
            return this.usedPaths;
        }

        String normalizePath(String path) {
            while (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path.replaceAll("\\{[^}]*}", "{}");
        }

        boolean isJAXRSParamAnnotation(java.lang.reflect.Parameter parameter) {
            return parameter.isAnnotationPresent(Multipart.class) || parameter.isAnnotationPresent(PathParam.class) || parameter.isAnnotationPresent(QueryParam.class) || parameter.isAnnotationPresent(CookieParam.class) || parameter.isAnnotationPresent(FormParam.class) || parameter.isAnnotationPresent(BeanParam.class) || parameter.isAnnotationPresent(HeaderParam.class) || parameter.isAnnotationPresent(MatrixParam.class);
        }

        boolean isJAXRSParamAnnotationUsedInMethod(Method method) {
            for (java.lang.reflect.Parameter parameter : method.getParameters()) {
                if (!this.isJAXRSParamAnnotation(parameter)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv;
            Method originalMethod = ASMUtils.findMethod(this.originalClassMethodsByName, (String)name, (String)descriptor);
            if (originalMethod == null) {
                throw new IllegalStateException("Method is not found in the original class");
            }
            Class<?> returnType = this.extractOriginalType(originalMethod.getReturnType());
            boolean hasResponse = returnType == Response.class;
            descriptor = hasResponse ? descriptor : Type.getMethodDescriptor((Type)Type.getType(Response.class), (Type[])Type.getArgumentTypes((String)descriptor));
            boolean allParametersIsPrimitive = true;
            Class<?>[] originalParameterTypes = originalMethod.getParameterTypes();
            int numOfParameters = originalParameterTypes.length;
            for (java.lang.reflect.Parameter parameter : originalMethod.getParameters()) {
                if (JAXRSOpenLServiceEnhancerHelper.isParameterInWrapperClass(parameter)) continue;
                --numOfParameters;
            }
            if (numOfParameters <= 3) {
                for (AnnotatedElement annotatedElement : originalParameterTypes) {
                    if (((Class)annotatedElement).isPrimitive()) continue;
                    allParametersIsPrimitive = false;
                    break;
                }
            }
            if (numOfParameters <= 3 && allParametersIsPrimitive && this.httpAnnotationIsNotPresented(originalMethod) || originalMethod.isAnnotationPresent(GET.class)) {
                StringBuilder sb = new StringBuilder();
                mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                String[] parameterNames = this.resolveParameterNames(originalMethod);
                this.processAnnotationsOnMethodParameters(originalMethod, mv);
                this.addGetAnnotation(mv, originalMethod);
                if (!originalMethod.isAnnotationPresent(Path.class)) {
                    Set<String> usedPathParamValues = this.getUsedValuesInParamAnnotations(originalMethod, PathParam.class, PathParam::value);
                    boolean bl = false;
                    for (String paramName : parameterNames) {
                        void var16_23;
                        java.lang.reflect.Parameter parameter = originalMethod.getParameters()[var16_23];
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam == null) {
                            Object p = paramName;
                            int j = 1;
                            while (usedPathParamValues.contains(p)) {
                                p = paramName + j;
                            }
                            sb.append("/{").append((String)p).append(": .*}");
                            this.addPathParamAnnotation(mv, (int)var16_23, (String)p);
                            usedPathParamValues.add((String)p);
                        } else {
                            sb.append("/{").append(pathParam.value()).append(": .*}");
                        }
                        ++var16_23;
                    }
                    if (!originalMethod.isAnnotationPresent(Path.class)) {
                        String path = "/" + originalMethod.getName() + sb;
                        int c = 1;
                        while (this.getUsedPaths().contains(this.normalizePath(path))) {
                            path = "/" + originalMethod.getName() + c++ + sb;
                        }
                        this.getUsedPaths().add(this.normalizePath(path));
                        this.addPathAnnotation(mv, originalMethod, path);
                    }
                } else {
                    Set<String> usedQueryParamValues = this.getUsedValuesInParamAnnotations(originalMethod, QueryParam.class, QueryParam::value);
                    boolean bl = false;
                    for (String paramName : parameterNames) {
                        void var16_25;
                        boolean jaxrsAnnotationPresented = this.isJAXRSParamAnnotation(originalMethod.getParameters()[var16_25]);
                        if (!jaxrsAnnotationPresented) {
                            Object p = paramName;
                            int j = 1;
                            while (usedQueryParamValues.contains(p)) {
                                p = paramName + j;
                            }
                            this.addQueryParamAnnotation(mv, (int)var16_25, (String)p);
                            usedQueryParamValues.add((String)p);
                        }
                        ++var16_25;
                    }
                }
            } else {
                try {
                    String path = null;
                    int c = 0;
                    if (!originalMethod.isAnnotationPresent(Path.class)) {
                        path = "/" + originalMethod.getName();
                        while (this.getUsedPaths().contains(this.normalizePath(path))) {
                            path = "/" + originalMethod.getName() + ++c;
                        }
                        this.getUsedPaths().add(this.normalizePath(path));
                    }
                    if (numOfParameters > 1) {
                        if (!this.isJAXRSParamAnnotationUsedInMethod(originalMethod)) {
                            mv = super.visitMethod(access, name, this.changedParameterTypesDescription(descriptor, originalMethod, c), signature, exceptions);
                            this.processAnnotationsOnMethodExternalParameters(originalMethod, mv);
                        } else {
                            mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                            this.processAnnotationsOnMethodParameters(originalMethod, mv);
                        }
                    } else {
                        mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                        this.processAnnotationsOnMethodParameters(originalMethod, mv);
                    }
                    if (!hasResponse) {
                        this.annotateReturnElementClass(mv, returnType);
                    }
                    if (this.httpAnnotationIsNotPresented(originalMethod)) {
                        this.addPostAnnotation(mv, originalMethod);
                    }
                    this.addPathAnnotation(mv, originalMethod, path);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            this.addConsumerProducesMethodAnnotations(mv, returnType, originalParameterTypes, originalMethod);
            Object nickname = originalMethod.getName();
            int c = 1;
            while (this.nicknames.contains(nickname)) {
                nickname = originalMethod.getName() + "_" + c++;
            }
            this.nicknames.add((String)nickname);
            this.addSwaggerMethodAnnotation(mv, originalMethod, (String)nickname);
            this.addOpenApiResponsesMethodAnnotation(mv, originalMethod);
            this.addOpenApiAcceptLanguageHeader(mv, originalMethod);
            return mv;
        }

        private boolean httpAnnotationIsNotPresented(Method originalMethod) {
            return !originalMethod.isAnnotationPresent(POST.class) && !originalMethod.isAnnotationPresent(PATCH.class) && !originalMethod.isAnnotationPresent(DELETE.class) && !originalMethod.isAnnotationPresent(PUT.class) && !originalMethod.isAnnotationPresent(OPTIONS.class) && !originalMethod.isAnnotationPresent(HEAD.class);
        }

        private <T extends Annotation> Set<String> getUsedValuesInParamAnnotations(Method originalMethod, Class<T> annotationClass, Function<T, String> func) {
            HashSet<String> usedPathParamValues = new HashSet<String>();
            for (java.lang.reflect.Parameter parameter : originalMethod.getParameters()) {
                T annotation = parameter.getAnnotation(annotationClass);
                if (annotation == null) continue;
                usedPathParamValues.add(func.apply(annotation));
                break;
            }
            return usedPathParamValues;
        }

        private String[] resolveParameterNames(Method originalMethod) {
            IOpenMember openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember((Method)originalMethod, (Object)this.targetService);
            return MethodUtils.getParameterNames((IOpenMember)openMember, (Method)originalMethod, (boolean)this.provideRuntimeContext, (boolean)this.provideVariations);
        }

        private boolean isTextMediaType(Class<?> type) {
            if (type == Void.TYPE || type == Void.class) {
                return false;
            }
            if (type.isPrimitive()) {
                return true;
            }
            for (Class<?> cl : TEXT_MEDIA_TYPE_SET) {
                if (!cl.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        private void addConsumerProducesMethodAnnotations(MethodVisitor mv, Class<?> returnType, Class<?>[] originalParameterTypes, Method originalMethod) {
            AnnotationVisitor av2;
            AnnotationVisitor av;
            if (returnType != null && this.isTextMediaType(returnType) && !originalMethod.isAnnotationPresent(Produces.class)) {
                av = mv.visitAnnotation(Type.getDescriptor(Produces.class), true);
                av2 = av.visitArray("value");
                av2.visit(null, (Object)"text/plain;charset=UTF-8");
                av2.visitEnd();
                av.visitEnd();
            }
            if (originalParameterTypes.length == 1 && this.isTextMediaType(originalParameterTypes[0]) && !originalMethod.isAnnotationPresent(Consumes.class)) {
                av = mv.visitAnnotation(Type.getDescriptor(Consumes.class), true);
                av2 = av.visitArray("value");
                av2.visit(null, (Object)"text/plain");
                av2.visitEnd();
                av.visitEnd();
            }
        }

        private void processAnnotationsOnMethodExternalParameters(Method originalMethod, MethodVisitor mv) {
            int index = 1;
            for (java.lang.reflect.Parameter parameter : originalMethod.getParameters()) {
                if (JAXRSOpenLServiceEnhancerHelper.isParameterInWrapperClass(parameter)) continue;
                for (Annotation annotation : parameter.getAnnotations()) {
                    AnnotationVisitor av = mv.visitParameterAnnotation(index, Type.getDescriptor(annotation.annotationType()), true);
                    InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)av);
                }
                ++index;
            }
        }

        private void processAnnotationsOnMethodParameters(Method originalMethod, MethodVisitor mv) {
            int index = 0;
            Annotation[][] annotationArray = originalMethod.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    AnnotationVisitor av = mv.visitParameterAnnotation(index, Type.getDescriptor(annotation.annotationType()), true);
                    InterfaceTransformer.processAnnotation((Annotation)annotation, (AnnotationVisitor)av);
                }
                ++index;
            }
        }

        private void annotateReturnElementClass(MethodVisitor mv, Class<?> returnType) {
            if (Object.class == returnType || Void.class == returnType) {
                return;
            }
            AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(ElementClass.class), true);
            av.visit("response", (Object)Type.getType(returnType));
            av.visitEnd();
        }

        private void addPostAnnotation(MethodVisitor mv, Method originalMethod) {
            if (!originalMethod.isAnnotationPresent(POST.class)) {
                AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(POST.class), true);
                av.visitEnd();
            }
        }

        private void addGetAnnotation(MethodVisitor mv, Method originalMethod) {
            if (!originalMethod.isAnnotationPresent(GET.class)) {
                AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(GET.class), true);
                av.visitEnd();
            }
        }

        private void addPathAnnotation(MethodVisitor mv, Method originalMethod, String path) {
            if (!originalMethod.isAnnotationPresent(Path.class)) {
                AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(Path.class), true);
                av.visit("value", (Object)path);
                av.visitEnd();
            }
        }

        private void addSwaggerMethodAnnotation(MethodVisitor mv, Method originalMethod, String nickname) {
            if (!originalMethod.isAnnotationPresent(Operation.class)) {
                String summary = originalMethod.getReturnType().getSimpleName() + " " + MethodUtil.printMethod((String)originalMethod.getName(), (Class[])originalMethod.getParameterTypes(), (boolean)true);
                IOpenMember openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember((Method)originalMethod, (Object)this.targetService);
                IOpenMethod openMethod = openMember instanceof IOpenMethod ? (IOpenMethod)openMember : null;
                String detailedSummary = openMethod != null ? openMethod.getType().getDisplayName(2) + " " + MethodUtil.printSignature((IOpenMethodHeader)openMethod, (int)2) : originalMethod.getReturnType().getTypeName() + " " + MethodUtil.printMethod((String)originalMethod.getName(), (Class[])originalMethod.getParameterTypes(), (boolean)false);
                String truncatedSummary = summary.substring(0, Math.min(summary.length(), 120));
                AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(Operation.class), true);
                av.visit("operationId", (Object)nickname);
                av.visit("summary", (Object)truncatedSummary);
                av.visit("description", (Object)((openMethod != null ? "Rules method: " : "Method: ") + detailedSummary));
                av.visitEnd();
            }
        }

        private void addOpenApiResponsesMethodAnnotation(MethodVisitor mv, Method originalMethod) {
            if (!this.isApiResponsesSpecified(originalMethod)) {
                Class<?> type = this.extractOriginalType(originalMethod.getReturnType());
                boolean isVoidType = Void.TYPE == type || Void.class == type;
                AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(ApiResponses.class), true);
                Class<?> t = originalMethod.getReturnType();
                int dim = 0;
                while (t.isArray()) {
                    t = t.getComponentType();
                    ++dim;
                }
                AnnotationVisitor av1 = av.visitArray("value");
                if (isVoidType || !type.isPrimitive()) {
                    AnnotationVisitor noContentAv = av1.visitAnnotation(null, Type.getDescriptor(ApiResponse.class));
                    noContentAv.visit("responseCode", (Object)String.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
                    noContentAv.visit("description", (Object)"Successful operation");
                    noContentAv.visitEnd();
                }
                if (!isVoidType) {
                    AnnotationVisitor av2 = av1.visitAnnotation("responses", Type.getDescriptor(ApiResponse.class));
                    av2.visit("responseCode", (Object)String.valueOf(Response.Status.OK.getStatusCode()));
                    av2.visit("description", (Object)"Successful operation");
                    AnnotationVisitor av3 = av2.visitArray("content");
                    AnnotationVisitor av4 = av3.visitAnnotation("responses", Type.getDescriptor(Content.class));
                    if (dim < 2) {
                        this.addSchemaOpenApiAnnotation(av4, originalMethod.getReturnType());
                    } else {
                        this.addSchemaOpenApiAnnotation(av4, Object.class);
                    }
                    av4.visitEnd();
                    av3.visitEnd();
                    av2.visitEnd();
                }
                av1.visitEnd();
                av.visitEnd();
            }
        }

        private void addOpenApiAcceptLanguageHeader(MethodVisitor mv, Method originalMethod) {
            if (!originalMethod.isAnnotationPresent(Parameters.class) && !originalMethod.isAnnotationPresent(Parameter.class)) {
                AnnotationVisitor acceptLanguage = mv.visitAnnotation("Lio/swagger/v3/oas/annotations/Parameter;", true);
                acceptLanguage.visit("name", (Object)"Accept-Language");
                acceptLanguage.visitEnum("in", "Lio/swagger/v3/oas/annotations/enums/ParameterIn;", "HEADER");
                acceptLanguage.visit("example", (Object)"en-GB");
                AnnotationVisitor av1 = acceptLanguage.visitAnnotation("schema", "Lio/swagger/v3/oas/annotations/media/Schema;");
                av1.visit("name", (Object)"string");
                av1.visitEnd();
                acceptLanguage.visitEnd();
            }
        }

        private boolean isApiResponsesSpecified(Method originalMethod) {
            if (originalMethod.isAnnotationPresent(ApiResponses.class) || originalMethod.isAnnotationPresent(ApiResponse.class)) {
                return true;
            }
            if (originalMethod.isAnnotationPresent(Operation.class)) {
                Operation operationAnnotation = originalMethod.getAnnotation(Operation.class);
                return operationAnnotation.responses().length != 0;
            }
            return false;
        }

        private void addSchemaOpenApiAnnotation(AnnotationVisitor av, Class<?> type) {
            Class<?> extractedType;
            boolean isArrayOrCollection;
            boolean bl = isArrayOrCollection = type.isArray() || Collection.class.isAssignableFrom(type);
            if (isArrayOrCollection) {
                av = av.visitAnnotation("array", Type.getDescriptor(ArraySchema.class));
                Class clazz = type = Collection.class.isAssignableFrom(type) ? Object.class : type.getComponentType();
            }
            if ((extractedType = this.extractOriginalType(type)) != null) {
                type = extractedType;
            }
            AnnotationVisitor av1 = av.visitAnnotation("schema", Type.getDescriptor(Schema.class));
            if (type == Integer.class || type == Integer.TYPE || type == Short.class || type == Short.TYPE || type == Byte.class || type == Byte.TYPE) {
                av1.visit("type", (Object)"integer");
                av1.visit("format", (Object)"int32");
            } else if (type == Long.class || type == Long.TYPE) {
                av1.visit("type", (Object)"integer");
                av1.visit("format", (Object)"int64");
            } else if (type == Float.class || type == Float.TYPE) {
                av1.visit("type", (Object)"number");
                av1.visit("format", (Object)"float");
            } else if (type == Double.class || type == Double.TYPE) {
                av1.visit("type", (Object)"number");
                av1.visit("format", (Object)"double");
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                av1.visit("type", (Object)"boolean");
            } else if (type == Character.class || type == Character.TYPE) {
                av1.visit("type", (Object)"string");
            } else if (Map.class.isAssignableFrom(type)) {
                av1.visit("implementation", (Object)Type.getType(Object.class));
            } else {
                av1.visit("implementation", (Object)Type.getType(type));
            }
            av1.visitEnd();
            if (isArrayOrCollection) {
                av.visitEnd();
            }
        }

        private void addPathParamAnnotation(MethodVisitor mv, int index, String paramName) {
            AnnotationVisitor av = mv.visitParameterAnnotation(index, Type.getDescriptor(PathParam.class), true);
            av.visit("value", (Object)paramName);
            av.visitEnd();
        }

        private void addQueryParamAnnotation(MethodVisitor mv, int index, String paramName) {
            AnnotationVisitor av = mv.visitParameterAnnotation(index, Type.getDescriptor(QueryParam.class), true);
            av.visit("value", (Object)paramName);
            av.visitEnd();
        }

        private void addProducesAnnotation(ClassVisitor cv) {
            AnnotationVisitor av = cv.visitAnnotation(Type.getDescriptor(Produces.class), true);
            AnnotationVisitor av1 = av.visitArray("value");
            av1.visit(null, (Object)"application/json");
            av1.visitEnd();
            av.visitEnd();
        }

        private void addConsumesAnnotation(ClassVisitor cv) {
            AnnotationVisitor av = cv.visitAnnotation(Type.getDescriptor(Consumes.class), true);
            AnnotationVisitor av1 = av.visitArray("value");
            av1.visit(null, (Object)"application/json");
            av1.visitEnd();
            av.visitEnd();
        }

        private void addOpenApiResponsesAnnotation(ClassVisitor cv) {
            ApiErrors apiErrors;
            AnnotationVisitor av = cv.visitAnnotation(Type.getDescriptor(ApiResponses.class), true);
            AnnotationVisitor arrayAv = av.visitArray("value");
            ArrayList<Class> allUserApiResponses = new ArrayList<Class>();
            allUserApiResponses.add(JAXRSUserErrorResponse.class);
            allUserApiResponses.addAll(Arrays.asList(DEFAULT_API_ERROR_TYPES));
            if (this.originalClass.isAnnotationPresent(ApiErrors.class) && (apiErrors = this.originalClass.getDeclaredAnnotation(ApiErrors.class)).value() != null) {
                allUserApiResponses.addAll(Arrays.asList(apiErrors.value()));
            }
            this.addOpenApiResponseAnnotation(arrayAv, 422, UNPROCESSABLE_ENTITY_MESSAGE, allUserApiResponses.toArray(new Class[0]), UNPROCESSABLE_ENTITY_EXAMPLE, USER_ERROR_EXAMPLE);
            this.addOpenApiResponseAnnotation(arrayAv, Response.Status.BAD_REQUEST.getStatusCode(), BAD_REQUEST_MESSAGE, DEFAULT_API_ERROR_TYPES, BAD_REQUEST_EXAMPLE);
            this.addOpenApiResponseAnnotation(arrayAv, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), INTERNAL_SERVER_ERROR_MESSAGE, DEFAULT_API_ERROR_TYPES, INTERNAL_SERVER_ERROR_EXAMPLE);
            arrayAv.visitEnd();
            av.visitEnd();
        }

        private void addOpenApiResponseAnnotation(AnnotationVisitor av, int code, String message, Class<?>[] responseTypes, String ... jsonExamples) {
            AnnotationVisitor apiResponseAv = av.visitAnnotation(null, Type.getDescriptor(ApiResponse.class));
            apiResponseAv.visit("responseCode", (Object)String.valueOf(code));
            apiResponseAv.visit("description", (Object)message);
            AnnotationVisitor contentArrayAv = apiResponseAv.visitArray("content");
            AnnotationVisitor contentAv = contentArrayAv.visitAnnotation(null, Type.getDescriptor(Content.class));
            contentAv.visit("mediaType", (Object)"application/json");
            AnnotationVisitor schemaAv = contentAv.visitAnnotation("schema", Type.getDescriptor(Schema.class));
            if (responseTypes.length == 1) {
                schemaAv.visit("implementation", (Object)Type.getType(responseTypes[0]));
            } else {
                AnnotationVisitor oneOf = schemaAv.visitArray("oneOf");
                for (Class<?> respType : responseTypes) {
                    oneOf.visit(null, (Object)Type.getType(respType));
                }
                oneOf.visitEnd();
            }
            schemaAv.visitEnd();
            AnnotationVisitor examplesArrAv = contentAv.visitArray("examples");
            int exampleCnt = 1;
            for (String jsonExample : jsonExamples) {
                AnnotationVisitor exampleObjectAv = examplesArrAv.visitAnnotation(null, Type.getDescriptor(ExampleObject.class));
                exampleObjectAv.visit("value", (Object)jsonExample);
                if (jsonExamples.length > 1) {
                    exampleObjectAv.visit("name", (Object)("Example " + exampleCnt++));
                }
                exampleObjectAv.visitEnd();
            }
            examplesArrAv.visitEnd();
            contentAv.visitEnd();
            contentArrayAv.visitEnd();
            apiResponseAv.visitEnd();
        }

        private Class<?> extractOriginalType(Class<?> type) {
            Class extractedType = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter(type);
            return extractedType == null ? type : extractedType;
        }
    }
}

