/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.openl.gen.FieldDescription;
import org.openl.gen.POJOByteCodeGenerator;
import org.openl.gen.TypeDescription;
import org.openl.rules.ruleservice.publish.jaxrs.ParameterIndex;

class WrapperBeanClassGenerator
extends POJOByteCodeGenerator {
    private final String methodName;
    private final Map<String, FieldDescription> originalMethodTypes;

    WrapperBeanClassGenerator(String beanName, LinkedHashMap<String, FieldDescription> beanFields, TypeDescription parentType, Map<String, FieldDescription> parentFields, Map<String, FieldDescription> originalMethodTypes, String methodName) {
        super(beanName, beanFields, parentType, parentFields, Collections.emptySet(), false, false, true);
        this.methodName = Objects.requireNonNull(methodName, "methodName cannot be null");
        this.originalMethodTypes = originalMethodTypes;
    }

    private void addArgs(ClassWriter classWriter, Map<String, FieldDescription> beanFields) {
        Type objectType = Type.getType(Object.class);
        Type beanType = Type.getType((String)this.getBeanNameDescriptor());
        Method args = Method.getMethod((String)"java.lang.Object[] _args()");
        GeneratorAdapter ag = new GeneratorAdapter(1, args, null, null, (ClassVisitor)classWriter);
        ag.push(beanFields.size());
        ag.newArray(objectType);
        int i = 0;
        for (Map.Entry<String, FieldDescription> field : beanFields.entrySet()) {
            Type fieldType = Type.getType((String)field.getValue().getTypeDescriptor());
            ag.dup();
            ag.push(i);
            ag.loadThis();
            ag.getField(beanType, field.getKey(), fieldType);
            ag.valueOf(fieldType);
            ag.arrayStore(objectType);
            ++i;
        }
        ag.returnValue();
        ag.endMethod();
    }

    private void addOriginalMethodTypes(ClassWriter classWriter) {
        Type classType = Type.getType(Class.class);
        Method types = Method.getMethod((String)"java.lang.Class[] _types()");
        GeneratorAdapter tg = new GeneratorAdapter(9, types, null, null, (ClassVisitor)classWriter);
        tg.push(this.originalMethodTypes.size());
        tg.newArray(classType);
        int i = 0;
        for (Map.Entry<String, FieldDescription> field : this.originalMethodTypes.entrySet()) {
            Type fieldType = Type.getType((String)field.getValue().getTypeDescriptor());
            tg.dup();
            tg.push(i);
            tg.push(fieldType);
            tg.arrayStore(classType);
            ++i;
        }
        tg.returnValue();
        tg.endMethod();
    }

    private void addMethod(ClassWriter classWriter, String methodName) {
        Method method = Method.getMethod((String)"java.lang.String _method()");
        GeneratorAdapter mg = new GeneratorAdapter(9, method, null, null, (ClassVisitor)classWriter);
        mg.push(methodName);
        mg.returnValue();
        mg.endMethod();
    }

    protected void visitExtraByteCodeGeneration(ClassWriter classWriter) {
        this.addArgs(classWriter, this.getFields());
        this.addOriginalMethodTypes(classWriter);
        this.addMethod(classWriter, this.methodName);
    }

    protected void visitFieldVisitor(FieldVisitor fieldVisitor, String fieldName, FieldDescription field, String javaType, int index) {
        AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(Type.getDescriptor(ParameterIndex.class), true);
        annotationVisitor.visit("value", (Object)index);
        annotationVisitor.visitEnd();
    }
}

