/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import javax.xml.bind.annotation.XmlSeeAlso;

public final class InheritanceFixConverterHelper {
    private InheritanceFixConverterHelper() {
    }

    public static Class<?> extractParentClass(Class<?> clazz, ObjectMapper objectMapper) {
        if (clazz != null) {
            BeanDescription beanDesc;
            Class<?> parentClass = null;
            Class<?> baseClass = clazz;
            while (baseClass.getSuperclass() != null && baseClass.getSuperclass() != Object.class) {
                beanDesc = objectMapper.getSerializationConfig().introspect(TypeFactory.defaultInstance().constructType(baseClass.getSuperclass()));
                JsonSubTypes jsonSubTypes = (JsonSubTypes)beanDesc.getClassAnnotations().get(JsonSubTypes.class);
                if (jsonSubTypes != null && jsonSubTypes.value().length > 0) {
                    parentClass = baseClass.getSuperclass();
                }
                baseClass = baseClass.getSuperclass();
            }
            if (parentClass != null) {
                return parentClass;
            }
            baseClass = clazz;
            while (baseClass.getSuperclass() != null && baseClass.getSuperclass() != Object.class) {
                beanDesc = objectMapper.getSerializationConfig().introspect(TypeFactory.defaultInstance().constructType(baseClass.getSuperclass()));
                XmlSeeAlso xmlSeeAlso = (XmlSeeAlso)beanDesc.getClassAnnotations().get(XmlSeeAlso.class);
                if (xmlSeeAlso != null && xmlSeeAlso.value().length > 0) {
                    parentClass = baseClass.getSuperclass();
                }
                baseClass = baseClass.getSuperclass();
            }
            return parentClass;
        }
        return null;
    }
}

