/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.util.JAXBUtils;

public class ObjectMapperSupportModelResolver
extends ModelResolver {
    public ObjectMapperSupportModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    protected Object resolveDefaultValue(Annotated a, Annotation[] annotations, Schema schema) {
        Object defaultValue = super.resolveDefaultValue(a, annotations, schema);
        if (defaultValue instanceof String) {
            Class t = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter((Class)a.getRawType());
            Class rawType = t == null ? a.getRawType() : t;
            try {
                IString2DataConvertor convertor = String2DataConvertorFactory.getConvertor((Class)rawType);
                if (convertor != null) {
                    Object o = convertor.parse((String)defaultValue, null);
                    return ObjectMapperSupportModelResolver.processDates(o);
                }
            }
            catch (Exception ignore) {
                return null;
            }
        }
        return defaultValue;
    }

    private static Object processDates(Object o) {
        if (o instanceof Date) {
            return ((Date)o).toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (o instanceof Date[]) {
            Date[] t = (Date[])o;
            OffsetDateTime[] arr = new OffsetDateTime[t.length];
            for (int i = 0; i < t.length; ++i) {
                if (t[i] == null) continue;
                arr[i] = t[i].toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime();
            }
            return arr;
        }
        return o;
    }

    protected void resolveDiscriminatorProperty(JavaType type, ModelConverterContext context, io.swagger.v3.oas.models.media.Schema model) {
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        JsonTypeInfo typeInfo = (JsonTypeInfo)beanDesc.getClassAnnotations().get(JsonTypeInfo.class);
        if (typeInfo != null) {
            String typeInfoProp;
            if (beanDesc.getBeanClass().getSuperclass() != null) {
                BeanDescription superBeanDesc = this._mapper.getSerializationConfig().introspect(TypeFactory.defaultInstance().constructType(beanDesc.getBeanClass().getSuperclass()));
                JsonTypeInfo superJsonTypeInfo = (JsonTypeInfo)superBeanDesc.getClassInfo().getAnnotation(JsonTypeInfo.class);
                JsonSubTypes jsonSubTypes = (JsonSubTypes)superBeanDesc.getClassInfo().getAnnotation(JsonSubTypes.class);
                if (jsonSubTypes != null) {
                    for (JsonSubTypes.Type subType : jsonSubTypes.value()) {
                        if (subType.value() != type.getRawClass()) continue;
                        if (!Objects.equals(superJsonTypeInfo.property(), typeInfo.property())) break;
                        return;
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(typeInfoProp = typeInfo.property()))) {
                io.swagger.v3.oas.models.media.Schema modelToUpdate = model;
                if (StringUtils.isNotBlank((CharSequence)model.get$ref())) {
                    modelToUpdate = (io.swagger.v3.oas.models.media.Schema)context.getDefinedModels().get(model.get$ref().substring(21));
                }
                if (modelToUpdate.getProperties() == null || !modelToUpdate.getProperties().containsKey(typeInfoProp)) {
                    io.swagger.v3.oas.models.media.Schema discriminatorSchema = new StringSchema().name(typeInfoProp);
                    modelToUpdate.addProperties(typeInfoProp, discriminatorSchema);
                    if (modelToUpdate.getRequired() == null || !modelToUpdate.getRequired().contains(typeInfoProp)) {
                        modelToUpdate.addRequiredItem(typeInfoProp);
                    }
                }
            }
        }
    }

    protected Discriminator resolveDiscriminator(JavaType type, ModelConverterContext context) {
        Schema declaredSchemaAnnotation = AnnotationsUtils.getSchemaDeclaredAnnotation((Class)type.getRawClass());
        String disc = declaredSchemaAnnotation == null ? "" : declaredSchemaAnnotation.discriminatorProperty();
        boolean avoidDisc = false;
        if (disc.isEmpty()) {
            BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
            AnnotatedClass a = beanDesc.getClassInfo();
            JsonTypeInfo typeInfo = (JsonTypeInfo)a.getAnnotation(JsonTypeInfo.class);
            if (typeInfo != null) {
                disc = typeInfo.property();
            }
            if (StringUtils.isNotBlank((CharSequence)disc) && beanDesc.getBeanClass().getSuperclass() != null) {
                BeanDescription superBeanDesc = this._mapper.getSerializationConfig().introspect(TypeFactory.defaultInstance().constructType(beanDesc.getBeanClass().getSuperclass()));
                JsonTypeInfo superJsonTypeInfo = (JsonTypeInfo)superBeanDesc.getClassInfo().getAnnotation(JsonTypeInfo.class);
                JsonSubTypes jsonSubTypes = (JsonSubTypes)superBeanDesc.getClassInfo().getAnnotation(JsonSubTypes.class);
                if (jsonSubTypes != null) {
                    for (JsonSubTypes.Type subType : jsonSubTypes.value()) {
                        if (subType.value() != type.getRawClass()) continue;
                        avoidDisc = true;
                        break;
                    }
                }
                boolean bl = avoidDisc = avoidDisc && superJsonTypeInfo != null && Objects.equals(superJsonTypeInfo.property(), disc);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)disc) && !avoidDisc) {
            Discriminator discriminator = new Discriminator().propertyName(disc);
            if (declaredSchemaAnnotation != null) {
                DiscriminatorMapping[] mappings;
                for (DiscriminatorMapping mapping : mappings = declaredSchemaAnnotation.discriminatorMapping()) {
                    if (mapping.value().isEmpty() || mapping.schema().equals(Void.class)) continue;
                    discriminator.mapping(mapping.value(), RefUtils.constructRef((String)context.resolve(new AnnotatedType().type((Type)mapping.schema())).getName()));
                }
            }
            return discriminator;
        }
        return null;
    }
}

