/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.InheritanceFixConverterHelper;

public class OpenApiInheritanceFixConverter
implements ModelConverter {
    private final List<ModelConverter> converters;
    private final ObjectMapper objectMapper;

    public OpenApiInheritanceFixConverter(ObjectMapper objectMapper, List<ModelConverter> converters) {
        this.converters = Objects.requireNonNull(converters, "converters cannot be null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        ModelConverterContextImpl modelConverterContext = new ModelConverterContextImpl(this.converters);
        try {
            modelConverterContext.resolve(annotatedType);
            this.fixParentClasses(modelConverterContext);
            Schema schema = modelConverterContext.resolve(annotatedType);
            return schema;
        }
        finally {
            for (Map.Entry definedModel : modelConverterContext.getDefinedModels().entrySet()) {
                context.defineModel((String)definedModel.getKey(), (Schema)definedModel.getValue());
            }
        }
    }

    private void fixParentClasses(ModelConverterContextImpl modelConverterContext) {
        Map<AnnotatedType, Schema> modelByType = OpenApiInheritanceFixConverter.getModelByType(modelConverterContext);
        LinkedHashSet parentClasses = new LinkedHashSet();
        for (Map.Entry<AnnotatedType, Schema> entry : modelByType.entrySet()) {
            Class<?> parentClass;
            Class clazz = null;
            if (entry.getKey().getType() instanceof JavaType) {
                JavaType javaType = (JavaType)entry.getKey().getType();
                clazz = javaType.getRawClass();
            } else if (entry.getKey().getType() instanceof Class) {
                clazz = (Class)entry.getKey().getType();
            }
            if ((parentClass = InheritanceFixConverterHelper.extractParentClass(clazz, this.objectMapper)) == null) continue;
            parentClasses.add(parentClass);
        }
        Map<String, Schema> modelByNameInContext = OpenApiInheritanceFixConverter.getModelByName(modelConverterContext);
        Map<AnnotatedType, Schema> modelByTypeInContext = OpenApiInheritanceFixConverter.getModelByType(modelConverterContext);
        for (Class<?> parentClass : parentClasses) {
            ModelConverterContextImpl modelConverterContext1 = new ModelConverterContextImpl(this.converters);
            modelConverterContext1.resolve(new AnnotatedType().type(parentClass));
            modelByNameInContext.putAll(OpenApiInheritanceFixConverter.getModelByName(modelConverterContext1));
            modelByTypeInContext.putAll(OpenApiInheritanceFixConverter.getModelByType(modelConverterContext1));
        }
    }

    private static Map<AnnotatedType, Schema> getModelByType(ModelConverterContextImpl context) {
        try {
            Field modelByTypeField = ModelConverterContextImpl.class.getDeclaredField("modelByType");
            modelByTypeField.setAccessible(true);
            return (HashMap)modelByTypeField.get(context);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, Schema> getModelByName(ModelConverterContextImpl context) {
        try {
            Field modelByNameField = ModelConverterContextImpl.class.getDeclaredField("modelByName");
            modelByNameField.setAccessible(true);
            return (Map)modelByNameField.get(context);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

