/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.ModelResolver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.openapi.OpenAPIConfiguration;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.ObjectMapperSupportModelResolver;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiInheritanceFixConverter;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.OpenApiSupportConverter;

public final class OpenApiObjectMapperHack {
    private final List converters = this.getModelConverters();
    private List<Object> oldConverters;

    public void apply(ObjectMapper objectMapper) {
        ArrayList<ModelConverter> hackedConverters = new ArrayList<ModelConverter>();
        hackedConverters.add(new OpenApiSupportConverter());
        this.oldConverters = new ArrayList<Object>();
        for (Object converter : this.converters) {
            this.oldConverters.add(converter);
            hackedConverters.add((ModelConverter)(converter instanceof ModelResolver ? new ObjectMapperSupportModelResolver(objectMapper) : (ModelConverter)converter));
        }
        this.converters.clear();
        OpenApiInheritanceFixConverter openApiInheritanceFixConverter = new OpenApiInheritanceFixConverter(objectMapper, hackedConverters);
        this.converters.add(openApiInheritanceFixConverter);
    }

    public List<ModelConverter> getModelConverters() {
        try {
            ModelConverters modelConverters = ModelConverters.getInstance();
            Field convertersField = ModelConverters.class.getDeclaredField("converters");
            convertersField.setAccessible(true);
            return (List)convertersField.get(modelConverters);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void revert() {
        this.converters.clear();
        if (this.oldConverters != null) {
            this.converters.addAll(this.oldConverters);
        }
    }

    static {
        OpenAPIConfiguration.configure();
    }
}

