/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.jaxrs.swagger;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.rules.ruleservice.publish.jaxrs.swagger.SupportConverterHelper;
import org.openl.util.ClassUtils;
import org.openl.util.JAXBUtils;

public class OpenApiSupportConverter
implements ModelConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema<?> resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (annotatedType.getCtxAnnotations() != null && Arrays.stream(annotatedType.getCtxAnnotations()).anyMatch(e -> e instanceof XmlTransient)) {
            return null;
        }
        Class<Object> valueType = null;
        if (annotatedType.getType() instanceof JavaType) {
            JavaType javaType = (JavaType)annotatedType.getType();
            valueType = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter((Class)javaType.getRawClass());
        } else if (annotatedType.getType() instanceof Class) {
            valueType = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter((Class)((Class)annotatedType.getType()));
        } else if (annotatedType.getType() == null) {
            valueType = Object.class;
        }
        if (valueType != null) {
            Type oldType = annotatedType.getType();
            try {
                annotatedType.setType(valueType);
                Schema schema = chain.next().resolve(annotatedType, context, chain);
                return schema;
            }
            finally {
                annotatedType.setType(oldType);
            }
        }
        return this.modifySchemaWithAnnotatedType(annotatedType, chain.next().resolve(annotatedType, context, chain), context);
    }

    private Schema<?> modifySchemaWithAnnotatedType(AnnotatedType annotatedType, Schema<?> returnedSchema, ModelConverterContext context) {
        Schema schema = returnedSchema;
        if (schema != null && schema.getName() == null) {
            schema = context.resolve(annotatedType);
        }
        if (schema != null && schema.getProperties() != null) {
            Class t = null;
            if (annotatedType.getType() instanceof JavaType) {
                JavaType javaType = (JavaType)annotatedType.getType();
                t = javaType.getRawClass();
            } else if (annotatedType.getType() instanceof Class) {
                t = (Class)annotatedType.getType();
            }
            if (t != null) {
                List<Method> methods = SupportConverterHelper.getAllMethods(t);
                Set methodNames = methods.stream().map(Method::getName).collect(Collectors.toSet());
                for (Method m : methods) {
                    String getterMethod;
                    XmlElement xmlElementAnn;
                    Schema prop;
                    if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || (prop = (Schema)schema.getProperties().get(m.getName())) == null) continue;
                    String customPropertyName = null;
                    XmlAttribute xmlAttributeAnn = m.getAnnotation(XmlAttribute.class);
                    if (xmlAttributeAnn != null && !"".equals(xmlAttributeAnn.name()) && !"##default".equals(xmlAttributeAnn.name())) {
                        customPropertyName = xmlAttributeAnn.name();
                    }
                    if ((xmlElementAnn = m.getAnnotation(XmlElement.class)) != null && !"".equals(xmlElementAnn.name()) && !"##default".equals(xmlElementAnn.name())) {
                        customPropertyName = xmlElementAnn.name();
                    }
                    if (!methodNames.contains(getterMethod = ClassUtils.getter((String)prop.getName())) && customPropertyName != null) {
                        prop.setName(customPropertyName);
                        schema.getProperties().remove(m.getName());
                        schema.getProperties().put(prop.getName(), prop);
                        continue;
                    }
                    if (customPropertyName != null) continue;
                    if (prop.getName().startsWith("get")) {
                        prop.setName(prop.getName().substring(3));
                    }
                    if (prop.getName().startsWith("is")) {
                        prop.setName(prop.getName().substring(2));
                    }
                    schema.getProperties().remove(m.getName());
                    schema.getProperties().put(prop.getName(), prop);
                }
            }
        }
        return returnedSchema;
    }
}

