/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.ReferenceTypeUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

class InheritanceFixConverter
implements ModelConverter {
    private final List<ModelConverter> converters;

    public InheritanceFixConverter(List<ModelConverter> converters) {
        this.converters = Objects.requireNonNull(converters, "converters cannot be null");
    }

    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        ModelConverterContextImpl modelConverterContext = new ModelConverterContextImpl(this.converters);
        modelConverterContext.resolve(annotatedType);
        for (AnnotatedType aType : new LinkedHashSet<AnnotatedType>(modelConverterContext.modelByType.keySet())) {
            Class parentClass;
            Type type = aType.getType();
            Class clazz = null;
            if (type instanceof JavaType) {
                clazz = ((JavaType)type).getRawClass();
            } else if (type instanceof Class) {
                clazz = (Class)type;
            }
            for (parentClass = clazz; parentClass != null && parentClass.getSuperclass() != null && parentClass.getSuperclass() != Object.class; parentClass = parentClass.getSuperclass()) {
            }
            if (parentClass == clazz) continue;
            ModelConverterContextImpl modelConverterContext1 = new ModelConverterContextImpl(this.converters);
            modelConverterContext1.resolve(new AnnotatedType(parentClass));
            modelConverterContext1.getDefinedModels().forEach(modelConverterContext::defineModel);
            modelConverterContext.modelByType.putAll(modelConverterContext1.modelByType);
        }
        Schema<?> schema = modelConverterContext.resolve(annotatedType);
        modelConverterContext.getDefinedModels().forEach((arg_0, arg_1) -> ((ModelConverterContext)context).defineModel(arg_0, arg_1));
        return schema;
    }

    static class ModelConverterContextImpl
    implements ModelConverterContext {
        private final List<ModelConverter> converters;
        private final Map<String, Schema<?>> modelByName = new TreeMap();
        private final HashMap<AnnotatedType, Schema<?>> modelByType = new HashMap();
        private final Set<AnnotatedType> processedTypes = new HashSet<AnnotatedType>();

        public ModelConverterContextImpl(List<ModelConverter> converters) {
            this.converters = converters;
        }

        public Iterator<ModelConverter> getConverters() {
            return this.converters.iterator();
        }

        public void defineModel(String name, Schema model) {
            this.modelByName.put(name, model);
        }

        public void defineModel(String name, Schema model, Type type, String prevName) {
            this.defineModel(name, model, new AnnotatedType(type), prevName);
        }

        public void defineModel(String name, Schema model, AnnotatedType type, String prevName) {
            this.modelByName.put(name, model);
            if (StringUtils.isNotBlank((CharSequence)prevName) && !prevName.equals(name)) {
                this.modelByName.remove(prevName);
            }
            if (type != null && type.getType() != null) {
                this.modelByType.put(type, model);
            }
        }

        public Map<String, Schema> getDefinedModels() {
            return Collections.unmodifiableMap(this.modelByName);
        }

        public Schema<?> resolve(AnnotatedType type) {
            if (this.converters.isEmpty()) {
                return null;
            }
            AnnotatedType aType = ReferenceTypeUtils.unwrapReference((AnnotatedType)type);
            if (aType != null) {
                type = aType;
            }
            if (this.processedTypes.contains(type)) {
                return this.modelByType.get(type);
            }
            this.processedTypes.add(type);
            Iterator<ModelConverter> itr = this.converters.iterator();
            Schema resolved = itr.next().resolve(type, (ModelConverterContext)this, itr);
            if (resolved != null) {
                this.modelByType.put(type, resolved);
                if (resolved.getName() != null) {
                    this.modelByName.put(resolved.getName(), resolved);
                }
            } else {
                this.processedTypes.remove(type);
            }
            return resolved;
        }
    }
}

