/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.mixin.OpenAPIMixin;
import io.swagger.v3.core.jackson.mixin.SchemaMixin;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import org.openl.rules.openapi.BinarySchemaConverter;
import org.openl.rules.openapi.InheritanceFixConverter;
import org.openl.rules.openapi.ObjectMapperSupportModelResolver;
import org.openl.rules.openapi.OpenApiSupportConverter;

public class OpenAPIConfiguration {
    public static void configure() {
    }

    public static OpenAPI generateOpenAPI(Class<?> clazz, ObjectMapper objectMapper) {
        return OpenAPIConfiguration.generateOpenAPI(new OpenAPI(), clazz, objectMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OpenAPI generateOpenAPI(OpenAPI openAPI, Class<?> clazz, ObjectMapper objectMapper) {
        ModelConverters singleton = ModelConverters.getInstance();
        List<ModelConverter> converters = OpenAPIConfiguration.clearConverters(singleton);
        try {
            singleton.addConverter(OpenAPIConfiguration.getConverters(objectMapper));
            OpenAPI openAPI2 = new Reader(openAPI).read(clazz);
            return openAPI2;
        }
        finally {
            List<ModelConverter> ignore = OpenAPIConfiguration.clearConverters(singleton);
            ListIterator<ModelConverter> itr = converters.listIterator(converters.size());
            while (itr.hasPrevious()) {
                ModelConverter converter = itr.previous();
                singleton.addConverter(converter);
            }
        }
    }

    public static ModelConverter getConverters(ObjectMapper objectMapper) {
        ArrayList<ModelConverter> hackedConverters = new ArrayList<ModelConverter>();
        hackedConverters.add(OpenApiSupportConverter.INSTANCE);
        hackedConverters.add(BinarySchemaConverter.INSTANCE);
        hackedConverters.add((ModelConverter)new ObjectMapperSupportModelResolver(objectMapper));
        return new InheritanceFixConverter(hackedConverters);
    }

    private static List<ModelConverter> clearConverters(ModelConverters singleton) {
        ArrayList<ModelConverter> converters = new ArrayList<ModelConverter>(singleton.getConverters());
        for (ModelConverter converter : converters) {
            singleton.removeConverter(converter);
        }
        return converters;
    }

    static {
        PrimitiveType.customClasses().put("java.util.Locale", PrimitiveType.STRING);
        Json.mapper().addMixIn(Schema.class, OpenApiXmlIgnoreMixIn.class);
        Yaml.mapper().addMixIn(Schema.class, OpenApiXmlIgnoreMixIn.class);
        Json.mapper().addMixIn(OpenAPI.class, SortedOpenAPIMixin.class);
        Yaml.mapper().addMixIn(OpenAPI.class, SortedOpenAPIMixin.class);
        Json.mapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        Json.mapper().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        Json.mapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Json.mapper().enable(SerializationFeature.INDENT_OUTPUT);
        Json.mapper().setTimeZone(TimeZone.getDefault());
        Yaml.mapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        Yaml.mapper().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        Yaml.mapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Yaml.mapper().enable(SerializationFeature.INDENT_OUTPUT);
        Yaml.mapper().setTimeZone(TimeZone.getDefault());
        ModelConverters.getInstance().addConverter((ModelConverter)BinarySchemaConverter.INSTANCE);
    }

    @JsonPropertyOrder(value={"type", "format"}, alphabetic=true)
    static abstract class OpenApiXmlIgnoreMixIn
    extends SchemaMixin {
        OpenApiXmlIgnoreMixIn() {
        }

        @JsonPropertyOrder(alphabetic=true)
        public abstract Map<String, Object> getExtensions();

        @JsonIgnore
        public abstract XML getXml();
    }

    @JsonPropertyOrder(value={"openapi", "info", "externalDocs", "servers", "security", "tags", "paths", "components"}, alphabetic=true)
    static abstract class SortedOpenAPIMixin
    extends OpenAPIMixin {
        SortedOpenAPIMixin() {
        }

        @JsonPropertyOrder(alphabetic=true)
        public abstract Map<String, Object> getExtensions();
    }
}

