/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.openapi;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.util.JAXBUtils;

class OpenApiSupportConverter
implements ModelConverter {
    static final OpenApiSupportConverter INSTANCE = new OpenApiSupportConverter();

    OpenApiSupportConverter() {
    }

    public Schema<?> resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (annotatedType.getCtxAnnotations() != null && Arrays.stream(annotatedType.getCtxAnnotations()).anyMatch(e -> e instanceof XmlTransient)) {
            return null;
        }
        Object valueType = annotatedType.getType();
        if (valueType instanceof JavaType) {
            JavaType javaType = (JavaType)valueType;
            valueType = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter((Class)javaType.getRawClass());
        } else if (valueType instanceof Class) {
            valueType = JAXBUtils.extractValueTypeIfAnnotatedWithXmlJavaTypeAdapter((Class)((Class)valueType));
        } else if (valueType == null) {
            valueType = Object.class;
        }
        if (valueType != null) {
            annotatedType.setType((Type)valueType);
        }
        return chain.next().resolve(annotatedType, context, chain);
    }
}

