/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.kafka.databinding;

import java.io.IOException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.databinding.ServiceConfigurationException;
import org.openl.rules.ruleservice.kafka.conf.BaseKafkaConfig;
import org.openl.rules.ruleservice.kafka.conf.KafkaDeploy;
import org.openl.rules.ruleservice.kafka.conf.KafkaDeployUtils;
import org.openl.rules.ruleservice.kafka.databinding.KafkaConfigHolder;
import org.openl.rules.ruleservice.kafka.databinding.Type;
import org.openl.rules.serialization.JacksonObjectMapperFactoryBean;
import org.openl.rules.serialization.ProjectJacksonObjectMapperFactoryBean;

public class KafkaProjectJacksonObjectMapperFactoryBean
extends ProjectJacksonObjectMapperFactoryBean {
    private Type type;
    private KafkaDeploy kafkaDeploy;
    private BaseKafkaConfig kafkaConfig;
    private ServiceDescription serviceDescription;

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(ServiceDescription serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    private KafkaDeploy getKafkaDeploy() {
        if (this.kafkaDeploy == null) {
            try {
                this.kafkaDeploy = KafkaDeployUtils.getKafkaDeploy(this.getServiceDescription());
            }
            catch (IOException e) {
                throw new ServiceConfigurationException("Failed to load configuration for Kafka publisher.", e);
            }
        }
        return this.kafkaDeploy;
    }

    private BaseKafkaConfig getKafkaConfig() {
        if (this.kafkaConfig == null) {
            this.kafkaConfig = KafkaConfigHolder.getInstance().getKafkaConfig();
            if (this.kafkaConfig == null) {
                throw new ServiceConfigurationException("Failed to find configuration for Kafka publisher.");
            }
        }
        return this.kafkaConfig;
    }

    protected void applyProjectConfiguration() {
        super.applyProjectConfiguration();
        this.applyKafkaConfiguration();
        this.processRootClassNamesBindingSetting(this.getConfigurationValue("rootClassNamesBinding"));
        this.processJacksonPropertiesSettingBoolean(this.getConfigurationValue("jackson.caseInsensitiveProperties"), "jackson.caseInsensitiveProperties", arg_0 -> ((JacksonObjectMapperFactoryBean)this.getDelegate()).setCaseInsensitiveProperties(arg_0));
        this.processJacksonPropertiesSettingBoolean(this.getConfigurationValue("jackson.failOnUnknownProperties"), "jackson.failOnUnknownProperties", arg_0 -> ((JacksonObjectMapperFactoryBean)this.getDelegate()).setFailOnUnknownProperties(arg_0));
        this.processJacksonPropertiesSettingBoolean(this.getConfigurationValue("jackson.failOnEmptyBeans"), "jackson.failOnEmptyBeans", arg_0 -> ((JacksonObjectMapperFactoryBean)this.getDelegate()).setFailOnEmptyBeans(arg_0));
        this.processJacksonDefaultDateFormatSetting(this.getConfigurationValue("jackson.defaultDateFormat"));
        this.processJacksonDefaultTypingModeSetting(this.getConfigurationValue("jackson.defaultTypingMode"));
        this.processJacksonSerializationInclusionSetting(this.getConfigurationValue("jackson.serializationInclusion"));
        this.processJacksonJsonTypeInfoIdSetting(this.getConfigurationValue("jackson.jsonTypeInfoId"));
    }

    private Object getConfigurationValue(String configurationProperty) {
        Object value = Type.PRODUCER.equals((Object)this.getType()) ? this.getKafkaConfig().getProducerConfigs().get(configurationProperty) : (Type.CONSUMER.equals((Object)this.getType()) ? this.getKafkaConfig().getConsumerConfigs().get(configurationProperty) : null);
        if (value == null) {
            if (Type.PRODUCER.equals((Object)this.getType())) {
                value = this.getKafkaDeploy().getProducerConfigs().getProperty(configurationProperty);
            } else if (Type.CONSUMER.equals((Object)this.getType())) {
                value = this.getKafkaDeploy().getConsumerConfigs().getProperty(configurationProperty);
            }
            if (value == null && this.getServiceDescription().getConfiguration() != null) {
                value = this.getServiceDescription().getConfiguration().get(configurationProperty);
            }
        }
        return value;
    }

    protected void applyKafkaConfiguration() {
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

