/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.kafka.publish;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.kafka.publish.AmbiguousMethodException;
import org.openl.rules.ruleservice.kafka.publish.MethodNotFoundException;

public final class KafkaHelpers {
    private KafkaHelpers() {
    }

    public static String[] getMethodParameters(String methodParameters) {
        String[] parameterTypes = methodParameters.split(",");
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = parameterTypes[i].trim();
        }
        return parameterTypes;
    }

    public static Method findMethodInService(OpenLService service, String methodName, String methodParameters) throws RuleServiceInstantiationException {
        if (methodName == null) {
            throw new MethodNotFoundException("Method name is not found.");
        }
        int cnt = 0;
        Method method = null;
        for (Method m : service.getServiceClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            ++cnt;
        }
        if (cnt == 0) {
            throw new MethodNotFoundException(String.format("Method with name '%s' is not found in the service class.", methodName));
        }
        if (cnt == 1 && methodParameters == null) {
            return method;
        }
        if (cnt > 1 && methodParameters == null) {
            throw new AmbiguousMethodException(String.format("Multiple methods with the same name '%s' is found in the service class.", methodName));
        }
        String[] methodParametersSplitted = KafkaHelpers.getMethodParameters(methodParameters);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : service.getServiceClass().getMethods()) {
            if (!m.getName().equals(methodName) || !KafkaHelpers.isMethodParametersMatched(m.getParameterTypes(), methodParametersSplitted)) continue;
            methods.add(m);
        }
        if (methods.isEmpty()) {
            throw new MethodNotFoundException(String.format("Method with name '%s' and parameters '%s' is not found in the service class.", methodName, Arrays.stream(methodParametersSplitted).collect(Collectors.joining(",", "[", "]"))));
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        throw new AmbiguousMethodException(String.format("Multiple methods with the same name '%s' and parameters '%s' is found in the service class.", methodName, Arrays.stream(methodParametersSplitted).collect(Collectors.joining(",", "[", "]"))));
    }

    private static boolean isMethodParametersMatched(Class<?>[] classTypes, String[] types) {
        if (classTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < classTypes.length; ++i) {
            if ("*".equals(types[i]) || Objects.equals(classTypes[i].getSimpleName(), types[i]) || Objects.equals(classTypes[i].getCanonicalName(), types[i]) || Objects.equals(classTypes[i].getName(), types[i]) || Objects.equals(classTypes[i].getTypeName(), types[i])) continue;
            return false;
        }
        return true;
    }
}

