/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.kafka.ser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.openl.rules.datatype.gen.JavaBeanClassBuilder;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationHelper;
import org.openl.rules.ruleservice.kafka.RequestMessage;
import org.openl.rules.ruleservice.kafka.publish.KafkaHelpers;
import org.openl.rules.ruleservice.kafka.ser.RequestMessageFormatException;
import org.openl.rules.ruleservice.publish.common.MethodUtils;
import org.openl.types.IOpenMember;
import org.openl.util.ClassUtils;

public class RequestMessageDeserializer
implements Deserializer<RequestMessage> {
    private static final String UTF8 = "UTF8";
    private final ObjectMapper objectMapper;
    private final OpenLService service;
    private final Map<String, Map<String, Entry>> methodMap;
    private final Entry methodParametersWrapperClassInfo;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private String encoding = "UTF8";

    public RequestMessageDeserializer(OpenLService service, ObjectMapper objectMapper, Method method) throws Exception {
        this.service = Objects.requireNonNull(service, "service cannot be null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
        if (method != null) {
            this.methodParametersWrapperClassInfo = this.generateWrapperClass(method);
            this.methodMap = null;
        } else {
            this.methodMap = new HashMap<String, Map<String, Entry>>();
            this.methodParametersWrapperClassInfo = null;
        }
    }

    public RequestMessageDeserializer(OpenLService service, ObjectMapper objectMapper) throws Exception {
        this(service, objectMapper, null);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object encodingValue = configs.get("value.deserializer.encoding");
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    private Entry generateWrapperClass(Method m) throws Exception {
        IOpenMember openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember((Method)m, (Object)this.service.getServiceBean());
        String[] parameterNames = MethodUtils.getParameterNames((IOpenMember)openMember, (Method)m, (boolean)this.service.isProvideRuntimeContext(), (boolean)this.service.isProvideVariations());
        String beanName = "org.openl.rules.ruleservice.publish.kafka.ser.KafkaRequestDeserializer$" + m.getName() + "$" + RandomStringUtils.random((int)16, (boolean)true, (boolean)false);
        int i = 0;
        JavaBeanClassBuilder beanClassBuilder = new JavaBeanClassBuilder(beanName);
        for (Class<?> type : m.getParameterTypes()) {
            beanClassBuilder.addField(parameterNames[i], type.getName());
            ++i;
        }
        byte[] byteCode = beanClassBuilder.byteCode();
        Class wrapperClazz = ClassUtils.defineClass((String)beanName, (byte[])byteCode, (ClassLoader)this.service.getClassLoader());
        Field[] wrapperClazzFields = new Field[m.getParameterCount()];
        for (int j = 0; j < m.getParameterCount(); ++j) {
            wrapperClazzFields[j] = wrapperClazz.getDeclaredField(parameterNames[j]);
            wrapperClazzFields[j].setAccessible(true);
        }
        return new Entry(m, wrapperClazz, wrapperClazzFields);
    }

    public RequestMessage deserialize(String topic, byte[] data) {
        return null;
    }

    private String getStringFromHeaders(Headers headers, String key) throws UnsupportedEncodingException {
        Header header = headers.lastHeader(key);
        if (header != null) {
            return new String(header.value(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public RequestMessage deserialize(String topic, Headers headers, byte[] rawData) {
        if (this.methodParametersWrapperClassInfo != null) {
            try {
                return this.buildRequestMessage(this.methodParametersWrapperClassInfo, rawData);
            }
            catch (Exception e) {
                return new RequestMessage(this.methodParametersWrapperClassInfo.getMethod(), (Exception)new RequestMessageFormatException("Invalid message format.", e), rawData, this.encoding);
            }
        }
        Method m = null;
        try {
            String methodName = this.getStringFromHeaders(headers, "methodName");
            String methodParameters = this.getStringFromHeaders(headers, "methodParameters");
            Entry entry = this.getCachedMethodParametersWrapperClassInfo(methodName, methodParameters);
            if (entry == null) {
                m = KafkaHelpers.findMethodInService(this.service, methodName, methodParameters);
                entry = this.generateWrapperClass(m);
                this.putCachedMethodParametersWrapperClassInfo(methodName, methodParameters, entry);
            } else {
                m = entry.getMethod();
            }
            return this.buildRequestMessage(entry, rawData);
        }
        catch (Exception e) {
            return new RequestMessage(m, (Exception)new RequestMessageFormatException("Invalid message format.", e), rawData, this.encoding);
        }
    }

    protected RequestMessage buildRequestMessage(Entry entry, byte[] rawData) throws IOException, IllegalAccessException {
        Method method = entry.getMethod();
        int numOfParameters = method.getParameterCount();
        if (numOfParameters == 0) {
            return new RequestMessage(method, new Object[0], rawData, this.encoding);
        }
        if (numOfParameters == 1) {
            Object arg = this.objectMapper.readValue(new String(rawData, this.encoding), method.getParameterTypes()[0]);
            return new RequestMessage(method, new Object[]{arg}, rawData, this.encoding);
        }
        Object wrapperTarget = this.objectMapper.readValue(new String(rawData, this.encoding), entry.getWrapperClass());
        Object[] parameters = new Object[numOfParameters];
        Field[] wrapperClassFields = entry.getWrapperClassFields();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            parameters[i] = wrapperClassFields[i].get(wrapperTarget);
        }
        return new RequestMessage(method, parameters, rawData, this.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedMethodParametersWrapperClassInfo(String methodName, String methodParameters, Entry entry) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            Map t = this.methodMap.computeIfAbsent(methodName, e -> new HashMap());
            t.put(methodParameters, entry);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getCachedMethodParametersWrapperClassInfo(String methodName, String methodParameters) {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            Map<String, Entry> t = this.methodMap.get(methodName);
            if (t != null) {
                Entry entry = t.get(methodParameters);
                return entry;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    public void close() {
    }

    private static final class Entry {
        private final Method method;
        private final Class<?> wrapperClass;
        private final Field[] wrapperClassFields;

        public Entry(Method method, Class<?> wrapperClass, Field[] wrapperClassFields) {
            this.method = Objects.requireNonNull(method);
            this.wrapperClass = Objects.requireNonNull(wrapperClass);
            this.wrapperClassFields = Objects.requireNonNull(wrapperClassFields);
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getWrapperClass() {
            return this.wrapperClass;
        }

        public Field[] getWrapperClassFields() {
            return this.wrapperClassFields;
        }
    }
}

